/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.wizard;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.web.wizard.WizardAction;
import java.util.Map;

public class WizardInterceptor
implements Interceptor {
    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        String result = this.before(invocation);
        if (result != null) {
            return result;
        }
        return invocation.invoke();
    }

    protected String before(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        String shortCircuit = null;
        if (action instanceof WizardAction) {
            boolean actionRequested;
            WizardAction wizardAction = (WizardAction)((Object)action);
            wizardAction.clearErrors();
            OgnlValueStack stack = invocation.getStack();
            Map parameters = ActionContext.getContext().getParameters();
            boolean bl = actionRequested = parameters.containsKey("next") || parameters.containsKey("previous") || parameters.containsKey("cancel") || parameters.containsKey("submit");
            if (actionRequested) {
                if (wizardAction.isInitialised()) {
                    String[] actualStates = (String[])parameters.get("state");
                    String actualState = actualStates.length > 0 ? actualStates[0] : null;
                    String expectedState = wizardAction.getCurrentState().getStateName();
                    if (!expectedState.equals(actualState) && !wizardAction.getWizard().traverseBackwardTo(actualState)) {
                        shortCircuit = wizardAction.getWizard().restart();
                    }
                } else {
                    wizardAction.getWizard().addActionError(wizardAction.getText("wizard.state.lost"));
                    shortCircuit = wizardAction.getWizard().restart();
                }
            }
            stack.push((Object)wizardAction.getWizard());
            stack.push((Object)wizardAction.getCurrentState());
            invocation.addPreResultListener(new PreResultListener(){

                public void beforeResult(ActionInvocation invocation, String resultCode) {
                    WizardAction wizardAction = (WizardAction)((Object)invocation.getAction());
                    OgnlValueStack stack = invocation.getStack();
                    stack.push((Object)wizardAction.getCurrentState());
                }
            });
        }
        return shortCircuit;
    }

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }
}

