/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.wizard;

import com.opensymphony.xwork.ActionContext;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.web.wizard.OneStepWizard;
import com.zutubi.pulse.web.wizard.TwoStepWizard;
import com.zutubi.pulse.web.wizard.WizardAction;
import java.util.HashMap;
import junit.framework.TestCase;

public class WizardActionTest
extends TestCase {
    public WizardActionTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ActionContext.getContext().setSession(new HashMap());
    }

    protected void tearDown() throws Exception {
        ActionContext.getContext().setSession(null);
        super.tearDown();
    }

    public void testOneStepWizard() {
        WizardAction action = this.createWizard(OneStepWizard.class.getName());
        action.validate();
        WizardActionTest.assertFalse((boolean)action.hasErrors());
        WizardActionTest.assertEquals((String)"a", (String)action.execute());
        OneStepWizard wizard = (OneStepWizard)ActionContext.getContext().getSession().get(OneStepWizard.class.getName());
        WizardActionTest.assertTrue((boolean)wizard.state.isInitialised());
        action = this.createWizard(OneStepWizard.class.getName());
        action.setNext("next");
        action.validate();
        WizardActionTest.assertFalse((boolean)action.hasErrors());
        WizardActionTest.assertEquals((String)"success", (String)action.execute());
        WizardActionTest.assertTrue((boolean)wizard.state.isValidated());
        WizardActionTest.assertTrue((boolean)wizard.state.isExecuted());
        WizardActionTest.assertTrue((boolean)wizard.isComplete());
    }

    public void testTwoStepWizard() {
        WizardAction action = this.createWizard(TwoStepWizard.class.getName());
        action.validate();
        WizardActionTest.assertFalse((boolean)action.hasErrors());
        WizardActionTest.assertEquals((String)"one", (String)action.execute());
        TwoStepWizard wizard = (TwoStepWizard)ActionContext.getContext().getSession().get(TwoStepWizard.class.getName());
        WizardActionTest.assertTrue((boolean)wizard.stateOne.isInitialised());
        WizardActionTest.assertEquals((Object)wizard.stateOne, (Object)wizard.getCurrentState());
        action = this.createWizard(TwoStepWizard.class.getName());
        action.setNext("next");
        action.validate();
        WizardActionTest.assertFalse((boolean)action.hasErrors());
        WizardActionTest.assertEquals((String)"two", (String)action.execute());
        WizardActionTest.assertEquals((Object)wizard.stateTwo, (Object)wizard.getCurrentState());
        WizardActionTest.assertTrue((boolean)wizard.stateOne.isValidated());
        WizardActionTest.assertTrue((boolean)wizard.stateOne.isExecuted());
        WizardActionTest.assertFalse((boolean)wizard.isComplete());
        WizardActionTest.assertTrue((boolean)wizard.stateTwo.isInitialised());
        action = this.createWizard(TwoStepWizard.class.getName());
        action.setNext("next");
        action.validate();
        WizardActionTest.assertFalse((boolean)action.hasErrors());
        WizardActionTest.assertEquals((String)"success", (String)action.execute());
        WizardActionTest.assertTrue((boolean)wizard.stateTwo.isValidated());
        WizardActionTest.assertTrue((boolean)wizard.stateTwo.isExecuted());
        WizardActionTest.assertTrue((boolean)wizard.isComplete());
    }

    private WizardAction createWizard(String name) {
        WizardAction action = new WizardAction();
        action.setWizardClass(name);
        action.setObjectFactory(new ObjectFactory());
        return action;
    }
}

