/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.wizard;

import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.Validateable;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.ValidationAwareSupport;
import com.opensymphony.xwork.validator.DefaultActionValidatorManager;
import com.opensymphony.xwork.validator.ValidationException;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.wizard.Wizard;
import com.zutubi.pulse.web.wizard.WizardCompleteState;
import com.zutubi.pulse.web.wizard.WizardState;
import com.zutubi.pulse.xwork.TextProviderSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class BaseWizard
implements Wizard {
    private Stack<WizardState> history = new Stack();
    private static final Logger LOG = Logger.getLogger(BaseWizard.class);
    protected WizardState initialState;
    private WizardState currentState;
    protected WizardState finalState = new WizardCompleteState(this, "success");
    private Map<String, WizardState> states = new HashMap<String, WizardState>();
    private DefaultActionValidatorManager validationManager = new DefaultActionValidatorManager();
    private final ValidationAware validationAware = new ValidationAwareSupport();
    private TextProvider textProvider;
    private LocaleProvider localeProvider;

    public BaseWizard() {
        this.states.put("success", this.finalState);
    }

    public WizardState getCurrentState() {
        return this.currentState;
    }

    public WizardState getState(String name) {
        return this.states.get(name);
    }

    public void addState(WizardState state) {
        this.states.put(state.getStateName(), state);
    }

    public void addInitialState(WizardState state) {
        this.initialState = state;
        this.states.put(state.getStateName(), state);
    }

    public boolean isComplete() {
        return this.currentState == this.finalState;
    }

    public void process() {
    }

    public void cancel() {
    }

    public void initialise() {
        this.currentState = this.initialState;
        this.currentState.initialise();
    }

    public boolean traverseBackwardTo(String requestedState) {
        if (this.getState(requestedState) == null) {
            return false;
        }
        if (this.currentState.getStateName().equals(requestedState)) {
            return true;
        }
        while (this.history.size() > 0) {
            WizardState state = this.history.pop();
            if (!state.getStateName().equals(requestedState)) continue;
            this.currentState = state;
            return true;
        }
        return false;
    }

    public String traverseForward() {
        if (this.hasErrors()) {
            return this.currentState.getView();
        }
        this.currentState.execute();
        this.history.push(this.currentState);
        String nextState = this.currentState.getNextStateName();
        if (nextState == null) {
            this.addActionError("Unknown next state: " + nextState);
            return this.currentState.getView();
        }
        this.currentState = this.getState(nextState);
        this.clearErrors();
        this.currentState.initialise();
        return this.currentState.getView();
    }

    public String traverseBackward() {
        if (this.history.size() > 0) {
            this.currentState = this.history.pop();
        }
        return this.currentState.getView();
    }

    public String restart() {
        this.currentState = this.initialState;
        return this.currentState.getView();
    }

    public void validate() {
        this.clearErrors();
        assert (!this.hasErrors());
        try {
            this.validationManager.validate((Object)this.currentState, this.currentState.getClass().getName());
            if (Validateable.class.isAssignableFrom(this.currentState.getClass())) {
                ((Validateable)this.currentState).validate();
            }
        }
        catch (ValidationException e) {
            this.addActionError(e.getMessage());
        }
    }

    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = new TextProviderSupport(this.getClass(), this.localeProvider);
        }
        return this.textProvider;
    }

    public void addActionError(String anErrorMessage) {
        this.validationAware.addActionError(anErrorMessage);
    }

    public void addActionMessage(String aMessage) {
        this.validationAware.addActionMessage(aMessage);
    }

    public void addFieldError(String fieldName, String errorMessage) {
        this.validationAware.addFieldError(fieldName, errorMessage);
    }

    public Collection getActionMessages() {
        return this.validationAware.getActionMessages();
    }

    public boolean hasActionErrors() {
        return this.validationAware.hasActionErrors();
    }

    public boolean hasActionMessages() {
        return this.validationAware.hasActionMessages();
    }

    public boolean hasFieldErrors() {
        return this.validationAware.hasFieldErrors();
    }

    public void setActionErrors(Collection errorMessages) {
        this.validationAware.setActionErrors(errorMessages);
    }

    public void setActionMessages(Collection messages) {
        this.validationAware.setActionMessages(messages);
    }

    public void setFieldErrors(Map errorMap) {
        this.validationAware.setFieldErrors(errorMap);
    }

    public Collection getActionErrors() {
        return this.validationAware.getActionErrors();
    }

    public Map getFieldErrors() {
        return this.validationAware.getFieldErrors();
    }

    public boolean hasErrors() {
        return this.validationAware.hasErrors();
    }

    public void clearErrors() {
        this.setActionErrors(null);
        this.setFieldErrors(null);
        this.setActionMessages(null);
    }
}

