/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.vfs;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.RandomUtils;
import com.zutubi.pulse.util.TempFileInputStream;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.web.vfs.VFSActionSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;

public class ZipAction
extends VFSActionSupport {
    private String root;
    private String path;
    private InputStream inputStream;
    private String filename;
    private MasterConfigurationManager configurationManager;
    private long contentLength;

    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws FileSystemException {
        if (TextUtils.stringSet((String)this.root)) {
            this.path = this.root + this.path;
        }
        FileObject fo = this.getFS().resolveFile(this.path);
        AbstractPulseFileObject pfo = (AbstractPulseFileObject)fo;
        File base = pfo.toFile();
        File tmpRoot = this.configurationManager.getSystemPaths().getTmpRoot();
        if (!tmpRoot.exists() && !tmpRoot.mkdirs()) {
            this.addActionError("Failed to create pulse temporary directory: " + tmpRoot.getAbsolutePath());
            return "error";
        }
        File temp = new File(tmpRoot, RandomUtils.randomString((int)7) + ".zip");
        try {
            FileSystemUtils.createZip((File)temp, (File)base.getParentFile(), (File)base);
            this.contentLength = temp.length();
            this.filename = base.getName() + ".zip";
            this.inputStream = new TempFileInputStream(temp);
        }
        catch (IOException e) {
            this.addActionError("I/O error zipping directory artifact: " + e.getMessage());
            String string = "error";
            return string;
        }
        finally {
            temp.delete();
        }
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

