/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.vfs;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.vfs.DirectoryComparator;
import com.zutubi.pulse.web.vfs.FileDepthFilterSelector;
import com.zutubi.pulse.web.vfs.FileObjectWrapper;
import com.zutubi.pulse.web.vfs.VFSActionSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileFilter;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

public class LsAction
extends VFSActionSupport {
    private static final Logger LOG = Logger.getLogger(LsAction.class);
    private boolean showFiles = false;
    private boolean showHidden = false;
    private int depth = 1;
    private String root;
    private String path;
    private List listing = null;

    public void setRoot(String root) {
        this.root = root;
    }

    public void setShowFiles(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public List getListing() {
        return this.listing;
    }

    public String execute() throws Exception {
        try {
            this.doList();
            return "success";
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            this.addActionError(e.getMessage());
            return "error";
        }
    }

    public void doList() throws FileSystemException {
        FileObject fo;
        if (TextUtils.stringSet((String)this.root)) {
            this.path = this.root + this.path;
        }
        if ((fo = this.getFS().resolveFile(this.path)).getType() != FileType.FOLDER) {
            return;
        }
        if (!fo.isReadable()) {
            this.addActionError("You do not have permission to list this folder.");
            return;
        }
        HashSet<FileType> acceptedTypes = new HashSet<FileType>();
        acceptedTypes.add(FileType.FOLDER);
        if (this.showFiles) {
            acceptedTypes.add(FileType.FILE);
        }
        this.listing = new LinkedList();
        FileObject[] children = fo.findFiles((FileSelector)new FileDepthFilterSelector(FileTypeFilter.accept(acceptedTypes), this.depth));
        if (children != null) {
            Collections.sort(Arrays.asList(children), new DirectoryComparator());
        }
        if (children != null) {
            for (FileObject child : children) {
                if (!this.showHidden && child.isHidden()) continue;
                this.listing.add(new FileObjectWrapper(child, fo));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListingPair {
        private String path;
        private List<String> listing;

        private ListingPair() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getListing() {
            return this.listing;
        }

        public void setListing(List<String> listing) {
            this.listing = listing;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTypeFilter
    implements FileFilter {
        private Collection<FileType> acceptedTypes = new HashSet<FileType>();

        private FileTypeFilter() {
        }

        public boolean accept(FileSelectInfo fileInfo) {
            try {
                return this.acceptedTypes.contains(fileInfo.getFile().getType());
            }
            catch (FileSystemException e) {
                return false;
            }
        }

        public static FileFilter accept(Collection<FileType> types) {
            FileTypeFilter filter = new FileTypeFilter();
            filter.acceptedTypes.addAll(types);
            return filter;
        }
    }
}

