/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.vfs;

import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileObjectWrapper {
    private static final Logger LOG = Logger.getLogger(FileObjectWrapper.class);
    private FileObject fo;
    private FileObject base;

    public FileObjectWrapper(FileObject fo, FileObject base) {
        this.fo = fo;
        this.base = base;
    }

    public String getName() {
        if (this.fo instanceof AbstractPulseFileObject) {
            return ((AbstractPulseFileObject)this.fo).getDisplayName();
        }
        return this.fo.getName().getBaseName();
    }

    public String getUrl() {
        try {
            if (this.fo instanceof AddressableFileObject) {
                return ((AddressableFileObject)this.fo).getUrlPath();
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return "";
    }

    public String getType() {
        try {
            if (this.fo instanceof AbstractPulseFileObject) {
                return ((AbstractPulseFileObject)this.fo).getFileType();
            }
            FileType type = this.fo.getType();
            if (type == FileType.FOLDER) {
                return "folder";
            }
            if (type == FileType.FILE) {
                return "file";
            }
            return "unknown";
        }
        catch (FileSystemException e) {
            LOG.warning((Throwable)e);
            return "unknown";
        }
    }

    public String getId() {
        return this.fo.getName().getBaseName();
    }

    public String getRelativeParentPath() {
        try {
            FileObject parent = this.fo.getParent();
            if (parent != null) {
                String path = this.base.getName().getRelativeName(parent.getName());
                if (path.equals(".")) {
                    path = "";
                }
                return path;
            }
        }
        catch (FileSystemException e) {
            LOG.severe((Throwable)e);
        }
        return "";
    }

    public boolean isContainer() {
        try {
            return this.fo.getType() == FileType.FOLDER;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    public String getSeparator() {
        return File.separator;
    }

    public List<String> getActions() {
        if (this.fo instanceof AbstractPulseFileObject) {
            return ((AbstractPulseFileObject)this.fo).getActions();
        }
        return Collections.EMPTY_LIST;
    }
}

