/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user.contact;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.EmailContactPoint;
import com.zutubi.pulse.model.JabberContactPoint;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.notifications.EmailNotificationHandler;
import com.zutubi.pulse.notifications.JabberNotificationHandler;
import com.zutubi.pulse.notifications.NotificationHandler;
import com.zutubi.pulse.notifications.NotificationSchemeManager;
import com.zutubi.pulse.util.Sort;
import com.zutubi.pulse.wizard.Wizard;
import com.zutubi.pulse.wizard.WizardTransition;
import com.zutubi.validation.Validateable;
import com.zutubi.validation.ValidationContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactPointWizard
implements Wizard,
Validateable {
    private UserManager userManager = null;
    private NotificationSchemeManager schemeManager = null;
    private ObjectFactory objectFactory = null;
    private SelectContact selectState;
    private Map<String, Object> handlers = new HashMap<String, Object>();
    private Object currentState;
    private long userId;

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getUserId() {
        return this.userId;
    }

    @Override
    public Object getCurrentState() {
        return this.currentState;
    }

    @Override
    public List<WizardTransition> getAvailableActions() {
        if (this.currentState == this.selectState) {
            return Arrays.asList(WizardTransition.NEXT, WizardTransition.CANCEL);
        }
        return Arrays.asList(WizardTransition.PREVIOUS, WizardTransition.FINISH, WizardTransition.CANCEL);
    }

    @Override
    public void doFinish() {
        User user = this.userManager.getUser(this.userId);
        NotificationHandler handler = (NotificationHandler)this.handlers.get(this.selectState.getContact());
        if (handler instanceof EmailNotificationHandler) {
            EmailNotificationHandler emailHandler = (EmailNotificationHandler)handler;
            EmailContactPoint email = new EmailContactPoint();
            email.setEmail(emailHandler.getEmail());
            email.setName(emailHandler.getName());
            user.add(email);
            this.userManager.save(user);
        } else if (handler instanceof JabberNotificationHandler) {
            JabberNotificationHandler jabberHandler = (JabberNotificationHandler)handler;
            JabberContactPoint jabber = new JabberContactPoint();
            jabber.setName(jabberHandler.getName());
            jabber.setUsername(jabberHandler.getUsername());
            user.add(jabber);
            this.userManager.save(user);
        }
    }

    @Override
    public Object doNext() {
        if (this.currentState == this.selectState) {
            this.currentState = this.handlers.get(this.selectState.getContact());
        }
        return this.currentState;
    }

    @Override
    public Object doPrevious() {
        this.currentState = this.selectState;
        return this.currentState;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void initialise() {
        List<String> schemes = this.schemeManager.getNotificationSchemes();
        Collections.sort(schemes, new Sort.StringComparator());
        this.selectState = new SelectContact(schemes);
        this.currentState = this.selectState;
        for (String scheme : schemes) {
            try {
                Class<? extends NotificationHandler> handlerClass = this.schemeManager.getNotificationHandler(scheme);
                Object handler = this.objectFactory.buildBean(handlerClass);
                this.handlers.put(scheme, handler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object doRestart() {
        this.currentState = this.selectState;
        return this.currentState;
    }

    public void validate(ValidationContext context) {
        String name;
        User user;
        ContactPoint contact;
        if (this.currentState instanceof NotificationHandler && (contact = (user = this.userManager.getUser(this.userId)).getContactPoint(name = ((NotificationHandler)this.currentState).getName())) != null) {
            context.addFieldError("name", context.getText("name.invalid"));
        }
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setNotificationSchemeManager(NotificationSchemeManager schemeManager) {
        this.schemeManager = schemeManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectContact {
        private String contact;
        private List<String> options;

        public SelectContact(List<String> options) {
            this.options = options;
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public List<String> getContactOptions() {
            return this.options;
        }
    }
}

