/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.condition.NotifyConditionFactory;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.PersonalBuildSubscription;
import com.zutubi.pulse.model.ProjectBuildSubscription;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.SubscriptionManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.renderer.BuildResultRenderer;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.web.user.SubscriptionHelper;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SubscriptionWizard
extends BaseWizard {
    private static final String PERSONAL_BUILDS_STATE = "personal";
    private static final String PROJECT_BUILDS_STATE = "project";
    private long userId;
    private UserManager userManager;
    private ProjectManager projectManager;
    private NotifyConditionFactory notifyConditionFactory;
    private BuildResultRenderer buildResultRenderer;
    private SubscriptionManager subscriptionManager;
    private SelectSubscriptionType selectState = new SelectSubscriptionType(this, "select");
    private ConfigurePersonal configPersonal = new ConfigurePersonal(this, "personal");
    private ConfigureProject configProject = new ConfigureProject(this, "project");

    public SubscriptionWizard() {
        this.addInitialState(this.selectState);
        this.addState(this.configPersonal);
        this.addState(this.configProject);
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public User getUser() {
        String principle = AcegiUtils.getLoggedInUser();
        if (principle != null) {
            return this.userManager.getUser(principle);
        }
        return null;
    }

    public void process() {
        Subscription subscription;
        ContactPoint contactPoint = this.getUser().getContactPoint(this.selectState.getContactId());
        if (this.selectState.getType().equals(PERSONAL_BUILDS_STATE)) {
            subscription = new PersonalBuildSubscription(contactPoint, this.configPersonal.getTemplate());
        } else {
            subscription = new ProjectBuildSubscription(contactPoint, this.configProject.getTemplate(), this.configProject.condition);
            this.configProject.helper.updateProjects((ProjectBuildSubscription)subscription);
        }
        this.subscriptionManager.save(subscription);
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setBuildResultRenderer(BuildResultRenderer buildResultRenderer) {
        this.buildResultRenderer = buildResultRenderer;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setNotifyConditionFactory(NotifyConditionFactory notifyConditionFactory) {
        this.notifyConditionFactory = notifyConditionFactory;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigureProject
    extends BaseWizardState
    implements Validateable {
        private SubscriptionHelper helper;
        private String condition;

        public ConfigureProject(Wizard wizard, String stateName) {
            super(wizard, stateName);
            this.condition = "true";
        }

        public String getTemplate() {
            return this.helper.getTemplate();
        }

        public void setTemplate(String template) {
            this.helper.setTemplate(template);
        }

        public List<Long> getProjects() {
            return this.helper.getProjects();
        }

        public void setProjects(List<Long> projects) {
            this.helper.setProjects(projects);
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public Map<String, String> getAvailableTemplates() {
            return this.helper.getAvailableTemplates();
        }

        public Map getConditions() {
            return this.helper.getConditions();
        }

        public Map<Long, String> getAllProjects() {
            return this.helper.getAllProjects();
        }

        @Override
        public void initialise() {
            Long contactId = SubscriptionWizard.this.selectState.getContactId();
            this.helper = new SubscriptionHelper(false, SubscriptionWizard.this.getUser(), SubscriptionWizard.this.getUser().getContactPoint(contactId), SubscriptionWizard.this.projectManager, SubscriptionWizard.this.notifyConditionFactory, SubscriptionWizard.this.getTextProvider(), SubscriptionWizard.this.buildResultRenderer);
        }

        @Override
        public String getNextStateName() {
            return "success";
        }

        public void validate() {
            this.helper.validateCondition(this.condition, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigurePersonal
    extends BaseWizardState {
        private SubscriptionHelper helper;

        public ConfigurePersonal(Wizard wizard, String stateName) {
            super(wizard, stateName);
        }

        public String getTemplate() {
            return this.helper.getTemplate();
        }

        public void setTemplate(String template) {
            this.helper.setTemplate(template);
        }

        public Map<String, String> getAvailableTemplates() {
            return this.helper.getAvailableTemplates();
        }

        @Override
        public void initialise() {
            Long contactId = SubscriptionWizard.this.selectState.getContactId();
            this.helper = new SubscriptionHelper(true, SubscriptionWizard.this.getUser(), SubscriptionWizard.this.getUser().getContactPoint(contactId), SubscriptionWizard.this.projectManager, SubscriptionWizard.this.notifyConditionFactory, SubscriptionWizard.this.getTextProvider(), SubscriptionWizard.this.buildResultRenderer);
        }

        @Override
        public String getNextStateName() {
            return "success";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectSubscriptionType
    extends BaseWizardState
    implements Validateable {
        private Map<String, String> types;
        private Map<Long, String> contacts;
        private String type;
        private Long contactId;

        public SelectSubscriptionType(Wizard wizard, String name) {
            super(wizard, name);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, String> getTypes() {
            return this.types;
        }

        public Map<Long, String> getContacts() {
            return this.contacts;
        }

        public Long getContactId() {
            return this.contactId;
        }

        public void setContactId(Long contactId) {
            this.contactId = contactId;
        }

        public void validate() {
            if (!TextUtils.stringSet((String)this.type) || !this.types.containsKey(this.type)) {
                this.addFieldError("type", "invalid type '" + this.type + "' specified. ");
            }
            if (SubscriptionWizard.this.getUser().getContactPoint(this.contactId) == null) {
                this.addFieldError("contactId", "Unknown contact point [" + this.contactId + "]");
            }
        }

        @Override
        public void initialise() {
            super.initialise();
            User user = SubscriptionWizard.this.getUser();
            if (user == null) {
                this.addActionError("Unknown user [" + SubscriptionWizard.this.userId + "]");
                return;
            }
            this.contacts = new LinkedHashMap<Long, String>();
            List<ContactPoint> contactPoints = user.getContactPoints();
            Collections.sort(contactPoints, new NamedEntityComparator());
            for (ContactPoint contact : contactPoints) {
                this.contacts.put(contact.getId(), contact.getName());
            }
            if (this.types == null) {
                this.types = new LinkedHashMap<String, String>();
                this.types.put(SubscriptionWizard.PERSONAL_BUILDS_STATE, "personal builds");
                this.types.put(SubscriptionWizard.PROJECT_BUILDS_STATE, "project builds");
            }
        }

        @Override
        public String getNextStateName() {
            if (TextUtils.stringSet((String)this.type)) {
                return this.type;
            }
            return super.getStateName();
        }
    }
}

