/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import antlr.MismatchedTokenException;
import antlr.collections.AST;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.ValidationAware;
import com.zutubi.pulse.condition.NotifyConditionFactory;
import com.zutubi.pulse.condition.antlr.NotifyConditionLexer;
import com.zutubi.pulse.condition.antlr.NotifyConditionParser;
import com.zutubi.pulse.condition.antlr.NotifyConditionTreeParser;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectBuildSubscription;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.renderer.BuildResultRenderer;
import com.zutubi.pulse.renderer.TemplateInfo;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionHelper {
    private User user;
    private ContactPoint contactPoint;
    private String template;
    private Map<String, String> availableTemplates;
    private Map<String, String> conditions;
    private Map<Long, String> allProjects;
    protected List<Long> projects = new LinkedList<Long>();
    private ProjectManager projectManager;
    private NotifyConditionFactory notifyConditionFactory;
    private TextProvider textProvider;

    public SubscriptionHelper(boolean personal, User user, ContactPoint contactPoint, ProjectManager projectManager, NotifyConditionFactory notifyConditionFactory, TextProvider textProvider, BuildResultRenderer buildResultRenderer) {
        this.user = user;
        this.contactPoint = contactPoint;
        this.projectManager = projectManager;
        this.notifyConditionFactory = notifyConditionFactory;
        this.textProvider = textProvider;
        this.availableTemplates = new TreeMap<String, String>();
        List<TemplateInfo> templates = buildResultRenderer.getAvailableTemplates(personal);
        for (TemplateInfo info : templates) {
            this.availableTemplates.put(info.getTemplate(), info.getDisplay());
        }
        this.template = this.getDefaultTemplate(this.availableTemplates);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    public Map<String, String> getAvailableTemplates() {
        return this.availableTemplates;
    }

    public Map getConditions() {
        if (this.conditions == null) {
            this.conditions = new LinkedHashMap<String, String>();
            this.conditions.put("true", this.textProvider.getText("condition.allbuilds"));
            this.conditions.put("not success", this.textProvider.getText("condition.allfailed"));
            this.conditions.put("changed", this.textProvider.getText("condition.allchanged"));
            this.conditions.put("changed or not success", this.textProvider.getText("condition.allchangedorfailed"));
            this.conditions.put("changed.by.me", this.textProvider.getText("condition.changedbyme"));
            this.conditions.put("changed.by.me and not success", this.textProvider.getText("condition.brokenbyme"));
            this.conditions.put("not success or state.change", this.textProvider.getText("condition.allfailedandfirstsuccess"));
            this.conditions.put("state.change", this.textProvider.getText("condition.statechange"));
        }
        return this.conditions;
    }

    public Map<Long, String> getAllProjects() {
        if (this.allProjects == null) {
            this.allProjects = new LinkedHashMap<Long, String>();
            List<Project> all = this.projectManager.getAllProjects();
            Collections.sort(all, new NamedEntityComparator());
            for (Project p : all) {
                this.allProjects.put(p.getId(), p.getName());
            }
        }
        return this.allProjects;
    }

    public void updateProjects(ProjectBuildSubscription subscription) {
        List<Project> subscriptionProjects = subscription.getProjects();
        subscriptionProjects.clear();
        for (Long id : this.projects) {
            Project p = this.projectManager.getProject(id);
            if (p == null) continue;
            subscriptionProjects.add(p);
        }
    }

    private String getDefaultTemplate(Map<String, String> availableTemplates) {
        String defaultTemplate = availableTemplates.keySet().iterator().next();
        String candidate = this.contactPoint.getDefaultTemplate();
        if (availableTemplates.containsKey(candidate)) {
            defaultTemplate = candidate;
        }
        return defaultTemplate;
    }

    public void validateCondition(String condition, ValidationAware action) {
        try {
            NotifyConditionLexer lexer = new NotifyConditionLexer(new StringReader(condition));
            NotifyConditionParser parser = new NotifyConditionParser(lexer);
            parser.orexpression();
            AST t = parser.getAST();
            if (t != null) {
                NotifyConditionTreeParser tree = new NotifyConditionTreeParser();
                tree.setNotifyConditionFactory(this.notifyConditionFactory);
                tree.cond(t);
            }
        }
        catch (MismatchedTokenException mte) {
            if (mte.token.getText() == null) {
                action.addFieldError("condition", "line " + mte.getLine() + ":" + mte.getColumn() + ": end of input when expecting " + NotifyConditionParser._tokenNames[mte.expecting]);
            } else {
                action.addFieldError("condition", mte.toString());
            }
        }
        catch (Exception e) {
            action.addFieldError("condition", e.toString());
        }
    }
}

