/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.util.Sort;
import com.zutubi.pulse.web.user.UserActionSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesAction
extends UserActionSupport {
    private List<ContactPoint> contactPoints;
    private List<Subscription> subscriptions;

    public List<ContactPoint> getContactPoints() {
        return this.contactPoints;
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public int getProjectCount() {
        return this.projectManager.getProjectCount();
    }

    public String getRefreshInterval() {
        long refreshInterval = this.getUser().getRefreshInterval();
        if (refreshInterval == (long)User.REFRESH_DISABLED) {
            return this.getText("user.refresh.never", "never");
        }
        return this.getText("user.refresh.every", Arrays.asList(this.getUser().getRefreshInterval()));
    }

    public String getTailRefreshInterval() {
        return this.getText("user.refresh.every", Arrays.asList(this.getUser().getTailRefreshInterval()));
    }

    public String doInput() throws Exception {
        String login = AcegiUtils.getLoggedInUser();
        if (login == null) {
            return "guest";
        }
        this.setUserLogin(login);
        User user = this.getUser();
        if (user == null) {
            this.addUnknownUserActionError();
            return "error";
        }
        final Sort.StringComparator comp = new Sort.StringComparator();
        this.contactPoints = new ArrayList<ContactPoint>(user.getContactPoints());
        Collections.sort(this.contactPoints, new NamedEntityComparator());
        this.subscriptions = new ArrayList<Subscription>(user.getSubscriptions());
        Collections.sort(this.subscriptions, new Comparator<Subscription>(){

            @Override
            public int compare(Subscription o1, Subscription o2) {
                return comp.compare(o1.getContactPoint().getName(), o2.getContactPoint().getName());
            }
        });
        return super.doInput();
    }

    public boolean canAddContact() {
        int supportedContactPoints = LicenseHolder.getLicense().getSupportedContactPoints();
        if (supportedContactPoints != -1) {
            return this.getUser().getContactPoints().size() < supportedContactPoints;
        }
        return true;
    }

    public String execute() throws Exception {
        String result = this.doInput();
        if (result.equals("input")) {
            return "success";
        }
        return result;
    }
}

