/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.zutubi.pulse.model.BuildColumns;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.web.ActionSupport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyBuildsAction
extends ActionSupport {
    private User user;
    private List<BuildResult> myBuilds;
    private BuildManager buildManager;
    private UserManager userManager;
    private BuildColumns columns;

    public User getUser() {
        return this.user;
    }

    public List<BuildResult> getMyBuilds() {
        return this.myBuilds;
    }

    public BuildColumns getColumns() {
        if (this.columns == null) {
            this.columns = new BuildColumns(this.user.getMyBuildsColumns(), this.projectManager);
        }
        return this.columns;
    }

    public String execute() throws Exception {
        String login = AcegiUtils.getLoggedInUser();
        if (login == null) {
            return "guest";
        }
        this.user = this.userManager.getUser(login);
        if (this.user == null) {
            return "error";
        }
        this.myBuilds = this.buildManager.getPersonalBuilds(this.user);
        return "success";
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

