/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.opensymphony.xwork.ValidationAware;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectBuildSubscription;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.web.user.SubscriptionActionSupport;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProjectBuildSubscriptionAction
extends SubscriptionActionSupport {
    private long id;
    private ProjectBuildSubscription subscription;
    private List<Long> projects = new LinkedList<Long>();
    private String template;
    private String condition;

    public EditProjectBuildSubscriptionAction() {
        super(false);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public Map<String, String> getAvailableTemplates() {
        return this.helper.getAvailableTemplates();
    }

    public Map getConditions() {
        return this.helper.getConditions();
    }

    public Map<Long, String> getAllProjects() {
        return this.helper.getAllProjects();
    }

    @Override
    public String doInput() throws Exception {
        super.doInput();
        if (this.hasErrors()) {
            return "error";
        }
        this.populateProjects(this.subscription);
        this.contactPointId = this.subscription.getContactPoint().getId();
        this.template = this.subscription.getTemplate();
        this.condition = this.subscription.getCondition();
        return "input";
    }

    public void populateProjects(ProjectBuildSubscription subscription) {
        for (Project p : subscription.getProjects()) {
            this.projects.add(p.getId());
        }
    }

    @Override
    public void validate() {
        this.lookupUser();
        if (this.hasErrors()) {
            return;
        }
        this.lookupSubscription();
        if (this.hasErrors()) {
            return;
        }
        this.contactPoint = this.subscription.getContactPoint();
        this.createHelper();
        this.helper.validateCondition(this.condition, (ValidationAware)this);
        super.validate();
    }

    public String execute() {
        this.subscription.setContactPoint(this.contactPoint);
        this.subscription.setTemplate(this.template);
        this.subscription.setCondition(this.condition);
        this.helper.setProjects(this.projects);
        this.helper.updateProjects(this.subscription);
        this.getSubscriptionManager().save(this.subscription);
        return "success";
    }

    @Override
    protected Subscription lookupSubscription() {
        Subscription s = this.user.getSubscription(this.id);
        if (s == null || !(s instanceof ProjectBuildSubscription)) {
            this.addActionError("Unknown subscription [" + this.id + "]");
            return null;
        }
        this.subscription = (ProjectBuildSubscription)s;
        return s;
    }
}

