/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.zutubi.pulse.model.User;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.web.user.UserActionSupport;
import org.acegisecurity.providers.encoding.PasswordEncoder;

public class EditPasswordAction
extends UserActionSupport {
    private String current;
    private String password;
    private String confirm;
    private PasswordEncoder passwordEncoder;

    public String getCurrent() {
        return this.current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public void validate() {
        User user = this.getUser();
        if (user == null) {
            this.addUnknownUserActionError();
            return;
        }
        if (!StringUtils.equals((String)this.password, (String)this.confirm)) {
            this.addFieldError("confirm", this.getText("password.confirm.mismatch"));
        }
        if (!this.passwordEncoder.isPasswordValid(user.getPassword(), this.current, null)) {
            this.addFieldError("current", this.getText("password.current.mismatch"));
        }
    }

    public String doInput() throws Exception {
        return super.doInput();
    }

    public String execute() throws Exception {
        User user = this.getUser();
        this.getUserManager().setPassword(user, this.password);
        this.getUserManager().save(user);
        return "success";
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

