/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.user;

import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.ChangelistComparator;
import com.zutubi.pulse.model.BuildColumns;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.web.ActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardAction
extends ActionSupport {
    private User user;
    private List<BuildResult> myBuilds;
    private List<Project> shownProjects;
    private List<ProjectGroup> shownGroups;
    private List<Changelist> changelists;
    private List<Changelist> projectChangelists = null;
    private BuildManager buildManager;
    private UserManager userManager;
    private boolean contactError = false;
    private BuildColumns columns;

    public User getUser() {
        return this.user;
    }

    public List<BuildResult> getMyBuilds() {
        return this.myBuilds;
    }

    public List<Project> getShownProjects() {
        return this.shownProjects;
    }

    public List<ProjectGroup> getShownGroups() {
        return this.shownGroups;
    }

    public BuildColumns getColumns() {
        if (this.columns == null) {
            this.columns = new BuildColumns(this.user.getMyProjectsColumns(), this.projectManager);
        }
        return this.columns;
    }

    public List<BuildResult> getLatestBuilds(Project p) {
        return this.buildManager.getLatestBuildResultsForProject(p, this.user.getDashboardBuildCount());
    }

    public List<Changelist> getChangelists() {
        return this.changelists;
    }

    public List<Changelist> getProjectChangelists() {
        return this.projectChangelists;
    }

    public boolean isContactError() {
        return this.contactError;
    }

    public String execute() throws Exception {
        String login = AcegiUtils.getLoggedInUser();
        if (login == null) {
            return "guest";
        }
        this.user = this.userManager.getUser(login);
        if (this.user == null) {
            return "error";
        }
        this.myBuilds = this.buildManager.getPersonalBuilds(this.user);
        this.shownProjects = this.user.getShowAllProjects() ? this.projectManager.getAllProjectsCached() : new ArrayList<Project>(this.user.getShownProjects());
        Collections.sort(this.shownProjects, new NamedEntityComparator());
        this.shownGroups = new ArrayList<ProjectGroup>(this.user.getShownGroups());
        Collections.sort(this.shownGroups, new NamedEntityComparator());
        this.changelists = this.buildManager.getLatestChangesForUser(this.user, this.user.getMyChangesCount());
        Collections.sort(this.changelists, new ChangelistComparator());
        Set<Project> projects = this.userManager.getUserProjects(this.user, this.projectManager);
        if (projects.size() > 0 && this.user.getShowProjectChanges()) {
            this.projectChangelists = this.buildManager.getLatestChangesForProjects(projects.toArray(new Project[0]), this.user.getProjectChangesCount());
        }
        for (ContactPoint contact : this.user.getContactPoints()) {
            if (!contact.hasError()) continue;
            this.contactError = true;
        }
        return "success";
    }

    public Project getProject(long id) {
        return this.projectManager.getProject(id);
    }

    public BuildResult getResult(long id) {
        return this.buildManager.getBuildResult(id);
    }

    @Override
    public boolean canWrite(Project project) {
        try {
            this.projectManager.checkWrite(project);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

