/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.setup;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Validateable;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.ValidatorContext;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SetupManager;
import com.zutubi.pulse.bootstrap.SystemConfigurationSupport;
import com.zutubi.pulse.model.AcegiUser;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import com.zutubi.pulse.xwork.validator.validators.EmailValidator;

public class SetupWizard
extends BaseWizard {
    private static final Logger LOG = Logger.getLogger(SetupWizard.class);
    private CreateAdminState createAdminState = new CreateAdminState(this, "admin");
    private ServerSettingsState serverSettingsState = new ServerSettingsState(this, "settings");
    private MasterConfigurationManager configurationManager;
    private UserManager userManager;
    private SetupManager setupManager;

    public SetupWizard() {
        this.addInitialState(this.createAdminState);
        this.addState(this.serverSettingsState);
    }

    public void process() {
        super.process();
        MasterConfiguration config = this.configurationManager.getAppConfig();
        User admin = this.createAdminState.getAdmin();
        admin.setEnabled(true);
        admin.add("ROLE_USER");
        admin.add("ROLE_ADMINISTRATOR");
        config.setAdminLogin(admin.getLogin());
        admin.setDefaultAction("welcome");
        this.userManager.save(admin);
        this.userManager.setPassword(admin, admin.getPassword());
        this.userManager.save(admin);
        Group adminGroup = new Group("administrators");
        adminGroup.addAdditionalAuthority("ROLE_ADMINISTRATOR");
        adminGroup.addAdditionalAuthority("ROLE_PERSONAL");
        this.userManager.addGroup(adminGroup);
        Group projectAdmins = new Group("project administrators");
        projectAdmins.addAdditionalAuthority("ROLE_PERSONAL");
        projectAdmins.setAdminAllProjects(true);
        this.userManager.addGroup(projectAdmins);
        Group developersGroup = new Group("developers");
        developersGroup.addAdditionalAuthority("ROLE_PERSONAL");
        this.userManager.addGroup(developersGroup);
        config.setBaseUrl(this.serverSettingsState.getBaseUrl());
        config.setSmtpFrom(this.serverSettingsState.getFromAddress());
        config.setSmtpHost(this.serverSettingsState.getSmtpHost());
        config.setSmtpSSL(this.serverSettingsState.getSmtpSSL());
        if (this.serverSettingsState.getSmtpCustomPort()) {
            config.setSmtpPort(this.serverSettingsState.getSmtpPort());
        }
        config.setSmtpSSL(this.serverSettingsState.getSmtpSSL());
        config.setSmtpUsername(this.serverSettingsState.getUsername());
        config.setSmtpPassword(this.serverSettingsState.getPassword());
        config.setSmtpPrefix(this.serverSettingsState.getPrefix());
        AcegiUtils.loginAs(new AcegiUser(admin));
        try {
            new Thread(new Runnable(){

                public void run() {
                    SetupWizard.this.setupManager.requestSetupComplete();
                }
            }).start();
        }
        catch (Exception e) {
            this.addActionError(e.getMessage());
            LOG.severe(e.getMessage(), (Throwable)e);
        }
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setSetupManager(SetupManager setupManager) {
        this.setupManager = setupManager;
    }

    public class ServerSettingsState
    extends BaseWizardState
    implements Validateable {
        private String baseUrl;
        private String fromAddress;
        private String smtpHost;
        private boolean smtpSSL;
        private boolean smtpCustomPort;
        private int smtpPort;
        private String username;
        private String password;
        private String prefix;

        public ServerSettingsState(Wizard wizard, String name) {
            super(wizard, name);
            this.smtpPort = 25;
        }

        public void initialise() {
            SystemConfigurationSupport systemConfig = (SystemConfigurationSupport)SetupWizard.this.configurationManager.getSystemConfig();
            this.baseUrl = systemConfig.getHostUrl();
        }

        public String getNextStateName() {
            return "success";
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getFromAddress() {
            return this.fromAddress;
        }

        public void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public String getSmtpHost() {
            return this.smtpHost;
        }

        public void setSmtpHost(String smtpHost) {
            this.smtpHost = smtpHost;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean getSmtpSSL() {
            return this.smtpSSL;
        }

        public void setSmtpSSL(boolean smtpSSL) {
            this.smtpSSL = smtpSSL;
        }

        public boolean getSmtpCustomPort() {
            return this.smtpCustomPort;
        }

        public void setSmtpCustomPort(boolean smtpCustomPort) {
            this.smtpCustomPort = smtpCustomPort;
        }

        public int getSmtpPort() {
            return this.smtpPort;
        }

        public void setSmtpPort(int smtpPort) {
            this.smtpPort = smtpPort;
        }

        public void validate() {
            if (TextUtils.stringSet((String)this.smtpHost) && !TextUtils.stringSet((String)this.fromAddress)) {
                this.addFieldError("fromAddress", "from address is required when smtp host is provided");
            }
            if (TextUtils.stringSet((String)this.fromAddress)) {
                EmailValidator validator = new EmailValidator();
                validator.setValidatorContext((ValidatorContext)new DelegatingValidatorContext((Object)this));
                validator.setFieldName("fromAddress");
                try {
                    validator.validate((Object)this);
                }
                catch (ValidationException e) {
                    this.addFieldError("fromAddress", e.getMessage());
                }
            }
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public class CreateAdminState
    extends BaseWizardState
    implements Validateable {
        private User admin;
        private String confirm;

        public CreateAdminState(Wizard wizard, String name) {
            super(wizard, name);
            this.admin = new User();
        }

        public void validate() {
            if (!this.confirm.equals(this.admin.getPassword())) {
                this.addFieldError("confirm", SetupWizard.this.getTextProvider().getText("admin.password.confirm.mismatch"));
            }
        }

        public String getNextStateName() {
            return SetupWizard.this.serverSettingsState.getStateName();
        }

        public User getAdmin() {
            return this.admin;
        }

        public String getConfirm() {
            return this.confirm;
        }

        public void setConfirm(String confirm) {
            this.confirm = confirm;
        }
    }
}

