/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.setup;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SetupManager;
import com.zutubi.pulse.bootstrap.conf.EnvConfig;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.web.setup.SetupActionSupport;
import java.io.File;
import java.io.IOException;

public class SetupDataAction
extends SetupActionSupport {
    private MasterConfigurationManager configurationManager;
    private SetupManager setupManager;
    private String data;
    private File pulseConfig;

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getPulseConfigPath() {
        return this.getPulseConfig().getAbsolutePath();
    }

    public boolean getPulseConfigExists() {
        return this.getPulseConfig().isFile();
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        File data = new File(this.data);
        if (!data.exists() && !data.mkdirs()) {
            this.addFieldError("data", "Failed to create the specified data directory.");
        }
        this.checkDirectoryIsWritable(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDirectoryIsWritable(File data) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("test", "tmp", data);
        }
        catch (IOException e) {
            this.addFieldError("data", "Failed to write to the selected data directory. Please ensure that pulse has permission to write to the specified data directory.");
        }
        finally {
            if (tmpFile != null && tmpFile.isFile()) {
                tmpFile.delete();
            }
        }
    }

    public File getPulseConfig() {
        if (this.pulseConfig == null) {
            EnvConfig envConfig = this.configurationManager.getEnvConfig();
            this.pulseConfig = envConfig.hasPulseConfig() ? new File(envConfig.getPulseConfig()) : new File(envConfig.getDefaultPulseConfig(".pulse"));
        }
        return this.pulseConfig;
    }

    public String doInput() throws Exception {
        String userHome = System.getProperty("user.home");
        if (TextUtils.stringSet((String)userHome)) {
            String userConfig = this.configurationManager.getEnvConfig().getDefaultPulseConfigDir(".pulse");
            this.data = FileSystemUtils.composeFilename((String[])new String[]{userConfig, "data"});
        } else {
            this.data = "data";
        }
        this.data = new File(this.data).getCanonicalPath();
        return "input";
    }

    public String execute() throws Exception {
        File home = new File(this.data);
        this.configurationManager.setPulseData(home);
        this.setupManager.requestDataComplete();
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setSetupManager(SetupManager setupManager) {
        this.setupManager = setupManager;
    }
}

