/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.charting.BuildResultsChart;
import com.zutubi.pulse.charting.BuildTimesChart;
import com.zutubi.pulse.charting.ChartUtils;
import com.zutubi.pulse.charting.DBBuildResultsDataSource;
import com.zutubi.pulse.charting.TestCountChart;
import com.zutubi.pulse.charting.TimeBasedChartData;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.persistence.BuildResultDao;
import com.zutubi.pulse.web.ActionSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewReportsAction
extends ActionSupport {
    private static final int WIDTH = 400;
    private static final int HEIGHT = 300;
    private long id;
    private Project project;
    private long specId = 0L;
    private Map<Long, String> buildSpecifications;
    private Map buildResultsChart;
    private Map testCountChart;
    private Map buildTimesChart;
    private Map stageTimesChart;
    private int timeframe = 45;
    private BuildResultDao buildResultDao;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(int timeframe) {
        this.timeframe = timeframe;
    }

    public Project getProject() {
        return this.project;
    }

    public String doInput() throws Exception {
        return this.execute();
    }

    public Map getTimeframes() {
        TreeMap<Integer, String> timeframes = new TreeMap<Integer, String>();
        timeframes.put(15, "15");
        timeframes.put(30, "30");
        timeframes.put(45, "45");
        timeframes.put(90, "90");
        return timeframes;
    }

    public long getSpecId() {
        return this.specId;
    }

    public void setSpecId(long specId) {
        this.specId = specId;
    }

    public Map<Long, String> getBuildSpecifications() {
        if (this.buildSpecifications == null) {
            this.buildSpecifications = new LinkedHashMap<Long, String>();
            List<BuildSpecification> specs = this.project.getBuildSpecifications();
            Collections.sort(specs, new NamedEntityComparator());
            for (BuildSpecification s : specs) {
                this.buildSpecifications.put(s.getId(), s.getName());
            }
        }
        return this.buildSpecifications;
    }

    public String execute() throws Exception {
        this.project = this.projectManager.getProject(this.id);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.id + "]");
            return "error";
        }
        BuildSpecification spec = null;
        if (this.specId > 0L) {
            spec = this.project.getBuildSpecification(this.specId);
        }
        if (spec == null) {
            spec = this.project.getBuildSpecifications().get(0);
            this.specId = spec.getId();
        }
        DBBuildResultsDataSource dataSource = new DBBuildResultsDataSource();
        dataSource.setProject(this.project);
        dataSource.setSpec(spec);
        dataSource.setBuildResultDao(this.buildResultDao);
        TimeBasedChartData chartData = new TimeBasedChartData();
        chartData.setSource(dataSource);
        chartData.setTimeframe(this.timeframe);
        BuildResultsChart chart = new BuildResultsChart();
        chart.setData(chartData);
        this.buildResultsChart = ChartUtils.renderForWeb(chart.render(), 400, 300);
        BuildTimesChart btChart = new BuildTimesChart(false);
        btChart.setData(chartData);
        this.buildTimesChart = ChartUtils.renderForWeb(btChart.render(), 400, 300);
        BuildTimesChart stChart = new BuildTimesChart(true);
        stChart.setData(chartData);
        this.stageTimesChart = ChartUtils.renderForWeb(stChart.render(), 400, 300);
        TestCountChart tcChart = new TestCountChart();
        tcChart.setData(chartData);
        this.testCountChart = ChartUtils.renderForWeb(tcChart.render(), 400, 300);
        return "success";
    }

    public Map getBuildResultsChart() {
        return this.buildResultsChart;
    }

    public Map getTestCountChart() {
        return this.testCountChart;
    }

    public Map getBuildTimesChart() {
        return this.buildTimesChart;
    }

    public Map getStageTimesChart() {
        return this.stageTimesChart;
    }

    public void setBuildResultDao(BuildResultDao buildResultDao) {
        this.buildResultDao = buildResultDao;
    }
}

