/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.File;

public class ViewPersonalChangesAction
extends ProjectActionSupport {
    private static final Logger LOG = Logger.getLogger(ViewPersonalChangesAction.class);
    private long id;
    private BuildResult result;
    private PatchArchive patchArchive;
    private MasterConfigurationManager configurationManager;

    public void setId(long id) {
        this.id = id;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public PatchArchive getPatchArchive() {
        return this.patchArchive;
    }

    public String execute() {
        this.result = this.getBuildManager().getBuildResult(this.id);
        if (this.result == null) {
            this.addActionError("Unknown build [" + this.id + "]");
            return "error";
        }
        if (!this.result.isPersonal()) {
            this.addActionError("Build [" + this.id + "] is not a personal build");
            return "error";
        }
        this.checkPermissions(this.result);
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File patchFile = paths.getUserPatchFile(this.getLoggedInUser().getId(), this.result.getNumber());
        if (!patchFile.exists()) {
            this.addActionError("Patch file not found");
            return "error";
        }
        try {
            this.patchArchive = new PatchArchive(patchFile);
        }
        catch (PulseException e) {
            LOG.warning((Throwable)e);
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

