/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.model.BuildColumns;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewBuildAction
extends ProjectActionSupport {
    public static final String FAILURE_LIMIT_PROPERTY = "pulse.test.failure.limit";
    public static final int DEFAULT_FAILURE_LIMIT = 100;
    private static final Logger LOG = Logger.getLogger(ViewBuildAction.class);
    private long id;
    private BuildResult result;
    private List<Changelist> changelists;
    private long selectedNode;
    private BuildColumns summaryColumns;
    private MasterConfigurationManager configurationManager;
    private Stack<String> pathStack = new Stack();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(long selectedNode) {
        this.selectedNode = selectedNode;
    }

    public boolean haveSelectedNode() {
        return this.selectedNode != 0L && this.selectedNode != this.result.getId();
    }

    @Override
    public Project getProject() {
        return this.result.getProject();
    }

    public BuildResult getResult() {
        return this.result;
    }

    public BuildColumns getSummaryColumns() {
        if (this.summaryColumns == null) {
            User u = this.getLoggedInUser();
            this.summaryColumns = new BuildColumns(u == null ? User.getDefaultProjectColumns() : u.getProjectSummaryColumns(), this.projectManager);
        }
        return this.summaryColumns;
    }

    public static int getFailureLimit() {
        int limit = 100;
        String property = System.getProperty(FAILURE_LIMIT_PROPERTY);
        if (property != null) {
            try {
                limit = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                LOG.warning((Throwable)e);
            }
        }
        return limit;
    }

    public void validate() {
    }

    public String execute() {
        this.result = this.getBuildManager().getBuildResult(this.id);
        if (this.result == null) {
            this.addActionError("Unknown build [" + this.id + "]");
            return "error";
        }
        this.checkPermissions(this.result);
        if (this.result.completed()) {
            this.result.loadFailedTestResults(this.configurationManager.getDataDirectory(), ViewBuildAction.getFailureLimit());
        }
        return "success";
    }

    public String appendSuitePath(String path, TestSuiteResult suite) {
        return path + "/" + this.urlEncode(suite.getName());
    }

    public String pushSuite(TestSuiteResult suite) {
        if (this.pathStack.empty()) {
            return this.pathStack.push(this.urlEncode(suite.getName()));
        }
        return this.pathStack.push(this.appendSuitePath(this.pathStack.peek(), suite));
    }

    public void popSuite() {
        this.pathStack.pop();
    }

    public List<Changelist> getChangelists() {
        if (this.changelists == null) {
            this.changelists = this.getBuildManager().getChangesForBuild(this.getResult());
        }
        return this.changelists;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

