/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.PlainFeature;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.CommandResultProvider;
import com.zutubi.pulse.vfs.pulse.FileArtifactProvider;
import com.zutubi.pulse.web.vfs.VFSActionSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewArtifactAction
extends VFSActionSupport {
    private static final Logger LOG = Logger.getLogger(ViewArtifactAction.class);
    private BuildManager buildManager;
    private BuildResult buildResult;
    private CommandResult commandResult;
    private StoredFileArtifact artifact;
    private BufferedReader reader;
    private Map<Long, Feature.Level> lineLevels;
    private String path;
    private String root;

    public void setPath(String path) {
        this.path = path;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public StoredFileArtifact getArtifact() {
        return this.artifact;
    }

    public ReaderIterator getReaderIterator() {
        return new ReaderIterator();
    }

    public Feature.Level getLineLevel(long line) {
        return this.lineLevels.get(line);
    }

    private void determineLineLevels() {
        this.lineLevels = new TreeMap<Long, Feature.Level>();
        for (Feature f : this.artifact.getFeatures()) {
            if (!(f instanceof PlainFeature)) continue;
            PlainFeature p = (PlainFeature)f;
            this.updateLevel(p.getLineNumber(), p.getLevel());
        }
    }

    public List<Feature.Level> getFeatureLevels() {
        List<Feature.Level> list = Arrays.asList(Feature.Level.values());
        Collections.reverse(list);
        return list;
    }

    private void updateLevel(long n, Feature.Level level) {
        if (this.lineLevels.containsKey(n) && level.compareTo((Enum)this.lineLevels.get(n)) > 0) {
            return;
        }
        this.lineLevels.put(n, level);
    }

    public String execute() throws FileSystemException {
        FileObject fo;
        if (TextUtils.stringSet((String)this.root)) {
            this.path = this.root + this.path;
        }
        if (!FileArtifactProvider.class.isAssignableFrom((fo = this.getFS().resolveFile(this.path)).getClass())) {
            return "error";
        }
        AbstractPulseFileObject pfo = (AbstractPulseFileObject)fo;
        this.buildResult = ((BuildResultProvider)((Object)pfo.getAncestor(BuildResultProvider.class))).getBuildResult();
        this.commandResult = ((CommandResultProvider)((Object)pfo.getAncestor(CommandResultProvider.class))).getCommandResult();
        this.artifact = this.buildManager.getFileArtifact(((FileArtifactProvider)((Object)pfo)).getFileArtifactId());
        File artifactFile = ((FileArtifactProvider)((Object)pfo)).getFile();
        if (!artifactFile.isFile()) {
            this.addActionError("LocalArtifact file '" + artifactFile.getAbsolutePath() + "' does not exist");
            return "error";
        }
        try {
            this.reader = new BufferedReader(new FileReader(artifactFile.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            this.addActionError("Unable to open artifact file: " + e.getMessage());
            return "error";
        }
        this.determineLineLevels();
        return "success";
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    class ReaderIterator
    implements Iterator {
        private boolean buffered = false;
        private String line;

        ReaderIterator() {
        }

        public boolean hasNext() {
            if (this.buffered) {
                return true;
            }
            try {
                this.line = ViewArtifactAction.this.reader.readLine();
                if (this.line != null) {
                    this.buffered = true;
                    return true;
                }
            }
            catch (IOException e) {
                LOG.severe("I/O error reading artifact: " + e.getMessage());
            }
            return false;
        }

        public Object next() {
            if (this.buffered) {
                this.buffered = false;
                String temp = this.line;
                this.line = null;
                return temp;
            }
            try {
                return ViewArtifactAction.this.reader.readLine();
            }
            catch (IOException e) {
                LOG.severe("I/O error reading artifact: " + e.getMessage());
                return "";
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

