/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.ManualTriggerBuildReason;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;

public class TriggerBuildAction
extends ProjectActionSupport {
    private long id = -1L;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void validate() {
    }

    public String execute() {
        Project project = this.getProjectManager().getProject(this.projectId);
        if (project == null) {
            this.addActionError("Trigger build request for unknown project [" + this.projectId + "]");
            return "error";
        }
        this.getProjectManager().checkWrite(project);
        BuildSpecification spec = this.id > 0L ? project.getBuildSpecification(this.id) : project.getDefaultSpecification();
        if (spec == null) {
            this.addActionError("Request to build unknown build specification id '" + this.id + "' for project '" + project.getName() + "'");
            return "error";
        }
        if (spec.getPrompt()) {
            return "prompt";
        }
        this.getProjectManager().triggerBuild(project, spec.getName(), new ManualTriggerBuildReason((String)this.getPrinciple()), null, true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "success";
    }
}

