/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;

public class ToggleTriggerAction
extends ProjectActionSupport {
    private static final Logger LOG = Logger.getLogger(ToggleTriggerAction.class);
    private long id;
    private boolean pause;

    public void setId(long id) {
        this.id = id;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public String execute() {
        Project project = this.getProjectManager().getProject(this.projectId);
        if (project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return "error";
        }
        this.getProjectManager().checkWrite(project);
        Trigger trigger = this.getScheduler().getTrigger(this.id);
        if (trigger == null) {
            this.addActionError("Unknown trigger [" + this.id + "]");
            return "error";
        }
        try {
            if (this.pause) {
                if (!trigger.isPaused()) {
                    this.getScheduler().pause(trigger);
                }
            } else if (trigger.isPaused()) {
                this.getScheduler().resume(trigger);
            }
        }
        catch (SchedulingException e) {
            LOG.severe((Throwable)((Object)e));
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }
}

