/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.PlainFeature;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.web.project.ViewArtifactAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TemporaryViewArtifactAction
extends ProjectActionSupport {
    private static final Logger LOG = Logger.getLogger(ViewArtifactAction.class);
    private long id;
    private long buildId;
    private long commandId;
    private BuildResult buildResult;
    private CommandResult commandResult;
    private StoredFileArtifact artifact;
    private BufferedReader reader;
    private Map<Long, Feature.Level> lineLevels;
    private MasterConfigurationManager configurationManager;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public long getCommandId() {
        return this.commandId;
    }

    public void setCommandId(long commandId) {
        this.commandId = commandId;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public StoredFileArtifact getArtifact() {
        return this.artifact;
    }

    public ReaderIterator getReaderIterator() {
        return new ReaderIterator();
    }

    public Feature.Level getLineLevel(long line) {
        return this.lineLevels.get(line);
    }

    private void determineLineLevels() {
        this.lineLevels = new TreeMap<Long, Feature.Level>();
        for (Feature f : this.artifact.getFeatures()) {
            if (!(f instanceof PlainFeature)) continue;
            PlainFeature p = (PlainFeature)f;
            this.updateLevel(p.getLineNumber(), p.getLevel());
        }
    }

    private void updateLevel(long n, Feature.Level level) {
        if (this.lineLevels.containsKey(n) && level.compareTo((Enum)this.lineLevels.get(n)) > 0) {
            return;
        }
        this.lineLevels.put(n, level);
    }

    public void validate() {
        this.buildResult = this.getBuildManager().getBuildResult(this.buildId);
        if (this.buildResult == null) {
            this.addActionError("Unknown build result [" + this.buildId + "]");
        }
        this.commandResult = this.getBuildManager().getCommandResult(this.commandId);
        if (this.commandResult == null) {
            this.addActionError("Unknown command result [" + this.commandId + "]");
        }
        this.artifact = this.getBuildManager().getFileArtifact(this.id);
        if (this.artifact == null) {
            this.addActionError("Unknown artifact [" + this.id + "]");
        }
    }

    public String execute() {
        File artifactFile = new File(this.commandResult.getAbsoluteOutputDir(this.configurationManager.getDataDirectory()), this.artifact.getPath());
        if (!artifactFile.isFile()) {
            this.addActionError("LocalArtifact file '" + artifactFile.getAbsolutePath() + "' does not exist");
            return "error";
        }
        try {
            this.reader = new BufferedReader(new FileReader(artifactFile.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            this.addActionError("Unable to open artifact file: " + e.getMessage());
            return "error";
        }
        this.determineLineLevels();
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    class ReaderIterator
    implements Iterator {
        private boolean buffered = false;
        private String line;

        ReaderIterator() {
        }

        public boolean hasNext() {
            if (this.buffered) {
                return true;
            }
            try {
                this.line = TemporaryViewArtifactAction.this.reader.readLine();
                if (this.line != null) {
                    this.buffered = true;
                    return true;
                }
            }
            catch (IOException e) {
                LOG.severe("I/O error reading artifact: " + e.getMessage());
            }
            return false;
        }

        public Object next() {
            if (this.buffered) {
                this.buffered = false;
                String temp = this.line;
                this.line = null;
                return temp;
            }
            try {
                return TemporaryViewArtifactAction.this.reader.readLine();
            }
            catch (IOException e) {
                LOG.severe("I/O error reading artifact: " + e.getMessage());
                return "";
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

