/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.util.CircularBuffer;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TailRecipeLogAction
extends ProjectActionSupport {
    private static final int LINE_COUNT = 30;
    private static final int MAX_BYTES = 15000;
    private long id;
    private long buildId;
    private int maxLines = -1;
    private int refreshInterval = -1;
    private BuildResult buildResult;
    private RecipeResultNode resultNode;
    private String tail = "";
    private MasterConfigurationManager configurationManager;
    private boolean logExists;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    public RecipeResultNode getResultNode() {
        return this.resultNode;
    }

    public String getTail() {
        return this.tail;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean getLogExists() {
        return this.logExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute() throws Exception {
        this.initialiseProperties();
        this.buildResult = this.getBuildManager().getBuildResult(this.buildId);
        if (this.buildResult == null) {
            this.addActionError("Unknown build [" + this.buildId + "]");
            return "error";
        }
        this.checkPermissions(this.buildResult);
        this.resultNode = this.buildResult.findResultNode(this.id);
        if (this.resultNode == null) {
            this.addActionError("Unknown stage [" + this.id + "]");
            return "error";
        }
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File recipeLog = new File(paths.getRecipeDir(this.buildResult, this.resultNode.getResult().getId()), "recipe.log");
        if (recipeLog.exists()) {
            this.logExists = true;
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(recipeLog, "r");
                long length = file.length();
                if (length <= 0L) return "success";
                if (length > 15000L) {
                    file.seek(length - 15000L);
                    length = 15000L;
                    file.readLine();
                }
                CircularBuffer buffer = new CircularBuffer(this.maxLines);
                String line = file.readLine();
                while (line != null) {
                    buffer.append((Object)line);
                    line = file.readLine();
                }
                StringBuilder builder = new StringBuilder((int)length);
                for (String l : buffer) {
                    builder.append(l);
                    builder.append('\n');
                }
                this.tail = builder.toString();
                return "success";
            }
            catch (IOException e) {
                this.addActionError("Error tailing log '" + recipeLog.getAbsolutePath() + "': " + e.getMessage());
                String string = "error";
                return string;
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        } else {
            this.logExists = false;
        }
        return "success";
    }

    private void initialiseProperties() {
        User user;
        Object principle = this.getPrinciple();
        if (principle != null && (user = this.userManager.getUser((String)principle)) != null) {
            boolean changed = false;
            if (this.refreshInterval <= 0) {
                this.refreshInterval = user.getTailRefreshInterval();
            } else if (this.refreshInterval != user.getTailRefreshInterval()) {
                user.setTailRefreshInterval(this.refreshInterval);
                changed = true;
            }
            if (this.maxLines <= 0) {
                this.maxLines = user.getTailLines();
            } else if (this.maxLines != user.getTailLines()) {
                user.setTailLines(this.maxLines);
                changed = true;
            }
            if (changed) {
                this.userManager.save(user);
            }
        }
        if (this.refreshInterval <= 0) {
            this.refreshInterval = 60;
        }
        if (this.maxLines <= 0) {
            this.maxLines = 30;
        }
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

