/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.committransformers.CommitMessageTransformerManager;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ScmManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.web.ActionSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.acegisecurity.AccessDeniedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectActionSupport
extends ActionSupport {
    protected BuildManager buildManager;
    protected ScmManager scmManager;
    protected UserManager userManager;
    protected Scheduler scheduler;
    private static final long NONE_SPECIFIED = -1L;
    private User loggedInUser = null;
    protected long projectId = -1L;
    protected String projectName = null;

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public ScmManager getScmManager() {
        return this.scmManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Feature.Level getErrorLevel() {
        return Feature.Level.ERROR;
    }

    public Feature.Level getWarningLevel() {
        return Feature.Level.WARNING;
    }

    public List<Feature.Level> getFeatureLevels() {
        List<Feature.Level> list = Arrays.asList(Feature.Level.values());
        Collections.reverse(list);
        return list;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Project getProject() {
        if (this.projectId != -1L) {
            return this.getProject(this.projectId);
        }
        if (TextUtils.stringSet((String)this.projectName)) {
            return this.getProject(this.projectName);
        }
        return null;
    }

    protected Project getProject(long id) {
        return this.projectManager.getProject(id);
    }

    protected Project getProject(String projectName) {
        return this.getProjectManager().getProject(projectName);
    }

    public void addUnknownProjectActionError() {
        if (this.projectId != -1L) {
            this.addActionError("Unknown project [" + this.projectId + "]");
        } else if (TextUtils.stringSet((String)this.projectName)) {
            this.addActionError("Unknown project [" + this.projectName + "]");
        } else {
            this.addActionError("Require either a project name or id.");
        }
    }

    public void addUnknownProjectFieldError() {
        if (this.projectId != -1L) {
            this.addFieldError("projectId", "Unknown project [" + this.projectId + "]");
        } else if (TextUtils.stringSet((String)this.projectName)) {
            this.addFieldError("projectName", "Unknown project [" + this.projectName + "]");
        } else {
            this.addActionError("Require either a project name or id.");
        }
    }

    public Project lookupProject(long id) {
        Project p = this.projectManager.getProject(id);
        if (p == null) {
            this.addActionError("Unknown project [" + id + "]");
        }
        return p;
    }

    public User getLoggedInUser() {
        Object principle;
        if (this.loggedInUser == null && (principle = this.getPrinciple()) != null && principle instanceof String) {
            this.loggedInUser = this.userManager.getUser((String)principle);
        }
        return this.loggedInUser;
    }

    public void checkPermissions(BuildResult result) {
        if (result.isPersonal()) {
            User user = this.getLoggedInUser();
            if (!result.getUser().equals((Object)user)) {
                throw new AccessDeniedException("Only the owner can view a personal build");
            }
        }
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public CommitMessageTransformerManager getTransformerManager() {
        return this.commitMessageTransformerManager;
    }
}

