/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.NamedEntityComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedEntityFormHelper<T extends NamedEntity> {
    protected abstract T get(long var1);

    protected abstract List<T> getAll();

    public Map<Long, String> getAllEntities() {
        List<T> all = this.getAll();
        Collections.sort(all, new NamedEntityComparator());
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (NamedEntity t : all) {
            result.put(t.getId(), t.getName());
        }
        return result;
    }

    public void convertFromIds(Collection<Long> entities, Collection<T> destination) {
        destination.clear();
        if (entities != null) {
            for (Long id : entities) {
                T t = this.get(id);
                if (t == null) continue;
                destination.add(t);
            }
        }
    }

    public List<Long> convertToIds(Collection<T> entities) {
        ArrayList<Long> result = new ArrayList<Long>(entities.size());
        for (NamedEntity t : entities) {
            result.add(t.getId());
        }
        return result;
    }
}

