/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildColumns;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.HistoryPage;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.PagingSupport;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryAction
extends ProjectActionSupport
implements Preparable {
    private static final int SURROUNDING_PAGES = 10;
    private static final String STATE_ANY = "";
    private static final String STATE_FAILURE_OR_ERROR = "failure or error";
    private static final String STATE_FAILURE = "failure";
    private static final String STATE_ERROR = "error";
    private static final String STATE_SUCCESS = "success";
    private long id;
    private Project project;
    private List<BuildResult> history;
    private PagingSupport pagingSupport = new PagingSupport(10);
    private Map<String, ResultState[]> nameToStates;
    private String stateFilter = "";
    private List<String> stateFilters;
    private Map<Long, String> specs;
    private Long spec = 0L;
    private BuildColumns columns;
    private MasterConfigurationManager configurationManager;

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setStartPage(int page) {
        this.pagingSupport.setStartPage(page);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public PagingSupport getPagingSupport() {
        return this.pagingSupport;
    }

    public List<BuildResult> getHistory() {
        return this.history;
    }

    public String getStateFilter() {
        return this.stateFilter;
    }

    public List<String> getStateFilters() {
        return this.stateFilters;
    }

    public void setStateFilter(String stateFilter) {
        this.stateFilter = stateFilter;
    }

    public Map<Long, String> getSpecs() {
        return this.specs;
    }

    public Long getSpec() {
        return this.spec;
    }

    public void setSpec(Long spec) {
        this.spec = spec;
    }

    public BuildColumns getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return null;
    }

    public void prepare() throws Exception {
        this.stateFilters = new LinkedList<String>();
        this.stateFilters.add(STATE_ANY);
        this.stateFilters.add(STATE_FAILURE_OR_ERROR);
        this.stateFilters.add(STATE_FAILURE);
        this.stateFilters.add(STATE_ERROR);
        this.stateFilters.add(STATE_SUCCESS);
        this.nameToStates = new TreeMap<String, ResultState[]>();
        this.nameToStates.put(STATE_ANY, new ResultState[]{ResultState.SUCCESS, ResultState.FAILURE, ResultState.ERROR});
        this.nameToStates.put(STATE_FAILURE_OR_ERROR, new ResultState[]{ResultState.FAILURE, ResultState.ERROR});
        this.nameToStates.put(STATE_FAILURE, new ResultState[]{ResultState.FAILURE});
        this.nameToStates.put(STATE_ERROR, new ResultState[]{ResultState.ERROR});
        this.nameToStates.put(STATE_SUCCESS, new ResultState[]{ResultState.SUCCESS});
    }

    public String execute() {
        this.project = this.getProjectManager().getProject(this.id);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.id + "]");
            return STATE_ERROR;
        }
        HashMap<Long, PersistentName> specNames = new HashMap<Long, PersistentName>();
        this.specs = new LinkedHashMap<Long, String>();
        this.specs.put(0L, STATE_ANY);
        for (PersistentName pname : this.getBuildManager().getBuildSpecifications(this.project)) {
            this.specs.put(pname.getId(), pname.getName());
            specNames.put(pname.getId(), pname);
        }
        if (this.pagingSupport.getStartPage() < 0) {
            this.addActionError("Invalid start page '" + this.pagingSupport.getStartPage() + "'");
            return STATE_ERROR;
        }
        HistoryPage page = new HistoryPage(this.project, this.pagingSupport.getStartOffset(), this.pagingSupport.getItemsPerPage());
        if (this.stateFilter.equals(STATE_ANY) && (this.spec == null || this.spec == 0L)) {
            this.getBuildManager().fillHistoryPage(page);
        } else {
            ResultState[] states = this.nameToStates.get(this.stateFilter);
            if (states == null) {
                this.addActionError("Invalid state filter '" + this.stateFilter + "'");
                return STATE_ERROR;
            }
            PersistentName specName = this.spec == null || this.spec == 0L ? null : (PersistentName)specNames.get(this.spec);
            this.getBuildManager().fillHistoryPage(page, states, specName);
        }
        this.history = page.getResults();
        this.pagingSupport.setTotalItems(page.getTotalBuilds());
        if (!this.pagingSupport.isStartPageValid()) {
            this.addActionError("Start page '" + this.pagingSupport.getStartPage() + "' is past the end of the results");
            return STATE_ERROR;
        }
        User user = this.getLoggedInUser();
        this.columns = new BuildColumns(user == null ? User.getDefaultProjectColumns() : user.getProjectHistoryColumns(), this.projectManager);
        return STATE_SUCCESS;
    }
}

