/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.PostProcessorManager;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditOutputProcessorsAction
extends ProjectActionSupport {
    private long projectId;
    private Project project;
    private Map<String, String> processorList;
    private List<String> processors;
    private PostProcessorManager postProcessorManager;

    @Override
    public long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public Map<String, String> getProcessorList() {
        if (this.processorList == null) {
            this.processorList = this.postProcessorManager.getAvailableProcessors();
        }
        return this.processorList;
    }

    public List<String> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<String> processors) {
        this.processors = processors;
    }

    public String doInput() {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project != null && this.project.getPulseFileDetails().isBuiltIn()) {
            TemplatePulseFileDetails details = (TemplatePulseFileDetails)this.project.getPulseFileDetails();
            this.processors = details.getOutputProcessors();
        }
        return "input";
    }

    public void validate() {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return;
        }
        if (!this.project.getPulseFileDetails().isBuiltIn()) {
            this.addActionError("Invalid operation for project");
        }
    }

    public String execute() {
        TemplatePulseFileDetails details = (TemplatePulseFileDetails)this.project.getPulseFileDetails();
        List<String> procs = details.getOutputProcessors();
        procs.clear();
        if (this.processors != null) {
            procs.addAll(this.processors);
        }
        this.getProjectManager().save(this.project);
        return "success";
    }

    public void setPostProcessorManager(PostProcessorManager postProcessorManager) {
        this.postProcessorManager = postProcessorManager;
    }
}

