/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.RunExecutablePostBuildAction;
import com.zutubi.pulse.web.project.AbstractEditPostBuildActionAction;
import java.util.LinkedList;
import java.util.List;

public class EditExeActionAction
extends AbstractEditPostBuildActionAction {
    private RunExecutablePostBuildAction action = new RunExecutablePostBuildAction();
    private Scope exampleScope;
    private MasterConfigurationManager configurationManager;

    public boolean isExe() {
        return true;
    }

    public Scope getExampleScope() {
        return this.exampleScope;
    }

    public void prepare() throws Exception {
        super.prepare();
        if (this.hasErrors()) {
            return;
        }
        PostBuildAction a = this.lookupAction();
        if (a == null) {
            return;
        }
        if (!(a instanceof RunExecutablePostBuildAction)) {
            this.addActionError("Invalid post build action type '" + a.getType() + "'");
            return;
        }
        this.action = (RunExecutablePostBuildAction)a;
        List<BuildResult> lastBuild = this.buildManager.queryBuilds(new Project[]{this.getProject()}, new ResultState[]{ResultState.SUCCESS}, null, -1L, -1L, null, 0, 1, true);
        if (!lastBuild.isEmpty()) {
            BuildResult result = lastBuild.get(0);
            List<RecipeResultNode> stages = result.getRoot().getChildren();
            RecipeResultNode node = null;
            if (this.isStage() && stages.size() > 0) {
                node = stages.get(0);
            }
            this.exampleScope = RunExecutablePostBuildAction.getScope(result, node, new LinkedList<ResourceProperty>(), this.configurationManager);
        }
    }

    public RunExecutablePostBuildAction getPostBuildAction() {
        return this.action;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

