/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.web.project.CleanupRuleActionSupport;
import java.util.LinkedList;

public class EditCleanupRuleAction
extends CleanupRuleActionSupport {
    private long id;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String doInput() throws Exception {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return "error";
        }
        CleanupRule rule = this.project.getCleanupRule(this.id);
        if (rule == null) {
            this.addActionError("Unknown cleanup rule [" + this.id + "]");
            return "error";
        }
        this.workDirOnly = rule.getWorkDirOnly();
        ResultState[] states = rule.getStates();
        if (states != null) {
            this.stateNames = new LinkedList();
            for (ResultState state : states) {
                this.stateNames.add(state.toString());
            }
        }
        this.limit = rule.getLimit();
        CleanupRule.CleanupUnit unit = rule.getUnit();
        this.buildUnits = unit == CleanupRule.CleanupUnit.BUILDS ? "builds" : "days";
        return "input";
    }

    public String execute() throws Exception {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return "error";
        }
        CleanupRule rule = this.project.getCleanupRule(this.id);
        if (rule == null) {
            this.addActionError("Unknown cleanup rule [" + this.id + "]");
            return "error";
        }
        ResultState[] states = this.calculateResultStates();
        CleanupRule.CleanupUnit units = this.calculateCleanupUnits();
        rule.setWorkDirOnly(this.workDirOnly);
        rule.setStates(states);
        rule.setLimit(this.limit);
        rule.setUnit(units);
        this.getProjectManager().save(this.project);
        return "success";
    }
}

