/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.ManualTriggerBuildReason;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditBuildPropertiesAction
extends ProjectActionSupport {
    private static final Logger LOG = Logger.getLogger(EditBuildPropertiesAction.class);
    private long id = -1L;
    private Project project;
    private BuildSpecification spec;
    private String revision;
    private List<ResourceProperty> properties;
    private static final String PROPERTY_PREFIX = "property.";

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public BuildSpecification getSpec() {
        return this.spec;
    }

    public List<ResourceProperty> getProperties() {
        return this.properties;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void validate() {
    }

    private void lookupSpec() {
        this.spec = this.id > 0L ? this.project.getBuildSpecification(this.id) : this.project.getDefaultSpecification();
        if (this.spec == null) {
            this.addActionError("Request to build unknown build specification id [" + this.id + "] for project '" + this.project.getName() + "'");
        }
    }

    public String doInput() throws Exception {
        this.project = this.lookupProject(this.projectId);
        if (this.hasErrors()) {
            return "error";
        }
        this.lookupSpec();
        if (this.hasErrors()) {
            return "error";
        }
        this.properties = new ArrayList<ResourceProperty>(this.spec.getProperties());
        Collections.sort(this.properties, new NamedEntityComparator());
        return "input";
    }

    public String execute() {
        this.project = this.lookupProject(this.projectId);
        if (this.hasErrors()) {
            return "error";
        }
        this.getProjectManager().checkWrite(this.project);
        this.lookupSpec();
        if (this.hasErrors()) {
            return "error";
        }
        this.mapProperties();
        this.projectManager.save(this.project);
        Revision r = null;
        if (TextUtils.stringSet((String)this.revision)) {
            try {
                r = this.project.getScm().createServer().getRevision(this.revision);
            }
            catch (SCMException e) {
                this.addFieldError("revision", "Unable to verify revision: " + e.getMessage());
                LOG.severe((Throwable)e);
                return "input";
            }
        }
        this.projectManager.triggerBuild(this.project, this.spec.getName(), new ManualTriggerBuildReason((String)this.getPrinciple()), r, true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "success";
    }

    private void mapProperties() {
        Map parameters = ActionContext.getContext().getParameters();
        for (Object n : parameters.keySet()) {
            String propertyName;
            ResourceProperty property;
            String name = (String)n;
            if (!name.startsWith(PROPERTY_PREFIX) || (property = this.spec.getProperty(propertyName = name.substring(PROPERTY_PREFIX.length()))) == null) continue;
            Object value = parameters.get(name);
            if (value instanceof String) {
                property.setValue((String)value);
                continue;
            }
            if (!(value instanceof String[])) continue;
            property.setValue(((String[])value)[0]);
        }
    }
}

