/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.scheduling.EventTrigger;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.web.project.AbstractEditTriggerAction;
import com.zutubi.pulse.web.project.BuildCompletedTriggerHelper;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditBuildCompletedTriggerAction
extends AbstractEditTriggerAction {
    private EventTrigger trigger = new EventTrigger();
    private BuildCompletedTriggerHelper helper = new BuildCompletedTriggerHelper();
    private Long filterProject;
    private String filterSpecification;
    private List<String> filterStateNames;

    public Long getFilterProject() {
        return this.filterProject;
    }

    public void setFilterProject(Long filterProject) {
        this.filterProject = filterProject;
    }

    public String getFilterSpecification() {
        return this.filterSpecification;
    }

    public void setFilterSpecification(String filterSpecification) {
        this.filterSpecification = filterSpecification;
    }

    public List<String> getFilterStateNames() {
        return this.filterStateNames;
    }

    public void setFilterStateNames(List<String> filterStateNames) {
        this.filterStateNames = filterStateNames;
    }

    @Override
    public void prepare() throws Exception {
        this.helper.initialise(this.getProjectManager());
        Trigger t = this.getScheduler().getTrigger(this.getId());
        if (t == null) {
            this.addActionError("Unknown trigger [" + this.getId() + "]");
            return;
        }
        if (!(t instanceof EventTrigger)) {
            this.addActionError("Invalid trigger type '" + t.getType() + "'");
            return;
        }
        this.trigger = (EventTrigger)t;
        Map<Serializable, Serializable> dataMap = this.trigger.getDataMap();
        this.filterProject = (Long)dataMap.get("other.project");
        this.filterSpecification = (String)((Object)dataMap.get("other.spec"));
        String states = (String)((Object)dataMap.get("build.states"));
        this.filterStateNames = new LinkedList<String>();
        for (ResultState r : ResultState.getStates((String)states)) {
            this.filterStateNames.add(r.toString());
        }
        super.prepare();
    }

    public Map<Long, String> getFilterProjects() {
        return this.helper.getFilterProjects();
    }

    public Map<Long, List<String>> getFilterSpecifications() {
        return this.helper.getFilterSpecifications();
    }

    public Map<String, String> getStateMap() {
        return this.helper.getStateMap();
    }

    @Override
    public EventTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public String execute() {
        this.helper.populateTrigger(this.trigger, this.filterProject, this.filterSpecification, this.filterStateNames);
        return super.execute();
    }
}

