/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.util.XMLUtils;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.InputStream;
import org.hsqldb.lib.StringInputStream;

public class DownloadProjectBuildFileAction
extends ProjectActionSupport {
    private long id;
    private InputStream inputStream;
    private long contentLength;

    public void setId(long id) {
        this.id = id;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return "application/xml";
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String execute() throws Exception {
        Project project = this.lookupProject(this.id);
        if (project == null) {
            return "error";
        }
        try {
            PulseFileDetails pulseFileDetails = project.getPulseFileDetails();
            ComponentContext.autowire((Object)((Object)pulseFileDetails));
            String pulseFile = XMLUtils.prettyPrint((String)pulseFileDetails.getPulseFile(0L, project, null, null));
            this.inputStream = new StringInputStream(pulseFile);
            this.contentLength = pulseFile.length();
        }
        catch (BuildException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }
}

