/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;

public class DeleteProjectAction
extends ProjectActionSupport {
    private long id;
    private Project project;
    private long totalBuilds;
    private String ok = null;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public long getTotalBuilds() {
        return this.totalBuilds;
    }

    public void setOk(String ok) {
        this.ok = ok;
    }

    private boolean lookupProject() {
        this.project = this.getProjectManager().getProject(this.id);
        if (this.project == null) {
            this.addActionError("Uknown project [" + this.id + "]");
            return false;
        }
        return true;
    }

    public String doInput() {
        if (!this.lookupProject()) {
            return "error";
        }
        this.totalBuilds = this.getBuildManager().getBuildCount(this.project, null, null);
        return "input";
    }

    public String execute() {
        if (!this.lookupProject()) {
            return "error";
        }
        if (this.ok != null) {
            this.project = this.getProjectManager().pauseProject(this.project);
            if (this.project.getState() != Project.State.PAUSED) {
                this.addActionError("The project is currently building.  Please wait for the project to pause and try again.");
                return "cancel";
            }
            this.getProjectManager().delete(this.project);
            return "success";
        }
        return "cancel";
    }
}

