/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;

public class CreatePropertyAction
extends ProjectActionSupport {
    private ResourceProperty property = new ResourceProperty();
    private long specId;
    private Project project;
    private BuildSpecification spec;

    public Project getProject() {
        return this.project;
    }

    public BuildSpecification getSpec() {
        return this.spec;
    }

    public ResourceProperty getProperty() {
        return this.property;
    }

    public void setProperty(ResourceProperty property) {
        this.property = property;
    }

    public long getSpecId() {
        return this.specId;
    }

    public void setSpecId(long specId) {
        this.specId = specId;
    }

    public String getValue() {
        return this.property.getValue();
    }

    public void setValue(String value) {
        this.property.setValue(value);
    }

    public String doInput() throws Exception {
        this.project = this.lookupProject(this.projectId);
        if (this.project != null) {
            this.spec = this.project.getBuildSpecification(this.specId);
        }
        return "input";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        this.project = this.lookupProject(this.projectId);
        if (this.hasErrors()) {
            return;
        }
        this.spec = this.project.getBuildSpecification(this.specId);
        if (this.spec == null) {
            this.addActionError("Unknown build specification [" + this.specId + "]");
            return;
        }
        if (this.spec.hasProperty(this.property.getName())) {
            this.addFieldError("property.name", "This specification already contains a property with name '" + this.property.getName() + "'");
        }
    }

    public String execute() {
        this.spec.addProperty(this.property);
        this.projectManager.save(this.project);
        return "success";
    }
}

