/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.xwork.ValidationAware;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.model.CustomPulseFileDetails;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.util.XMLUtils;
import com.zutubi.pulse.web.project.CustomDetailsHelper;
import com.zutubi.pulse.web.project.ProjectActionSupport;

public class ConvertToCustomProjectAction
extends ProjectActionSupport {
    private long id;
    private CustomPulseFileDetails details = new CustomPulseFileDetails();
    private CustomDetailsHelper detailsHelper = new CustomDetailsHelper();
    private Project project;
    private ResourceRepository resourceRepository;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public CustomPulseFileDetails getDetails() {
        return this.details;
    }

    public CustomDetailsHelper getDetailsHelper() {
        return this.detailsHelper;
    }

    public Project getProject() {
        return this.project;
    }

    public String doInput() {
        this.project = this.lookupProject(this.id);
        if (this.hasErrors()) {
            return "error";
        }
        PulseFileDetails pulseFileDetails = this.project.getPulseFileDetails();
        ComponentContext.autowire((Object)((Object)pulseFileDetails));
        String pulseFile = pulseFileDetails.getPulseFile(0L, this.project, null, null);
        this.details.setPulseFile(XMLUtils.prettyPrint((String)pulseFile));
        return "input";
    }

    public void validate() {
        this.project = this.lookupProject(this.id);
        if (this.hasErrors()) {
            return;
        }
        this.detailsHelper.validate((ValidationAware)this, this.details.getPulseFile(), this.resourceRepository);
    }

    public String execute() {
        this.project.setPulseFileDetails(this.details);
        this.getProjectManager().save(this.project);
        return "success";
    }

    public void setResourceRepository(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }
}

