/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.core.PulseFile;
import com.zutubi.pulse.core.PulseFileLoader;
import com.zutubi.pulse.core.Recipe;
import com.zutubi.pulse.core.RecipeListingPredicate;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.TypeLoadPredicate;
import com.zutubi.pulse.model.AnyCapableBuildHostRequirements;
import com.zutubi.pulse.model.BuildStage;
import com.zutubi.pulse.model.MasterBuildHostRequirements;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveBuildHostRequirements;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSpecificationActionSupport
extends ProjectActionSupport {
    private static final Logger LOG = Logger.getLogger(BuildSpecificationActionSupport.class);
    protected List<String> recipes;
    protected ResourceRepository resourceRepository;
    protected Project project;
    private SlaveManager slaveManager;
    private Map<Long, String> buildHosts;
    protected String name;
    protected Long buildHost = 0L;
    protected BuildStage stage = new BuildStage();

    @Override
    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProject(this.projectId);
        }
        return this.project;
    }

    public List<String> getRecipes() {
        if (this.recipes == null) {
            this.recipes = new LinkedList<String>();
            this.populateRecipes();
        }
        return this.recipes;
    }

    protected void populateRecipes() {
        this.recipes.add("");
        final LinkedList pulseFileRecipes = new LinkedList();
        final Semaphore doneSemaphore = new Semaphore(0);
        Thread populator = new Thread(new Runnable(){

            public void run() {
                PulseFileLoader fileLoader = new PulseFileLoader();
                fileLoader.setObjectFactory(new ObjectFactory());
                try {
                    PulseFileDetails details = BuildSpecificationActionSupport.this.getProject().getPulseFileDetails();
                    ComponentContext.autowire((Object)((Object)details));
                    String pulseFile = details.getPulseFile(0L, BuildSpecificationActionSupport.this.project, null, null);
                    PulseFile file = new PulseFile();
                    fileLoader.load((InputStream)new ByteArrayInputStream(pulseFile.getBytes()), (Object)file, null, BuildSpecificationActionSupport.this.resourceRepository, (TypeLoadPredicate)new RecipeListingPredicate());
                    for (Recipe r : file.getRecipes()) {
                        pulseFileRecipes.add(r.getName());
                    }
                }
                catch (Exception e) {
                    LOG.warning("Unable to load pulse file for project '" + BuildSpecificationActionSupport.this.project.getName() + "': " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
                doneSemaphore.release();
            }
        });
        populator.run();
        try {
            if (doneSemaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                this.recipes.addAll(pulseFileRecipes);
            }
        }
        catch (InterruptedException e) {
            LOG.warning((Throwable)e);
        }
    }

    public BuildStage getStage() {
        return this.stage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Long, String> getBuildHosts() {
        if (this.buildHosts == null) {
            List<Slave> slaves = this.slaveManager.getAll();
            this.buildHosts = new LinkedHashMap<Long, String>();
            this.buildHosts.put(0L, "[any]");
            this.buildHosts.put(1L, "master");
            for (Slave slave : slaves) {
                this.buildHosts.put(slave.getId(), slave.getName());
            }
        }
        return this.buildHosts;
    }

    public Long getBuildHost() {
        return this.buildHost;
    }

    public void setBuildHost(Long buildHost) {
        this.buildHost = buildHost;
    }

    protected void lookupAgent() {
        if (this.buildHost != 0L && this.buildHost != 1L && this.slaveManager.getSlave(this.buildHost) == null) {
            this.addActionError("Unknown agent [" + this.buildHost + "]");
        }
    }

    protected void addFieldsToStage() {
        this.stage.setName(this.name);
        if (this.buildHost == 0L) {
            this.stage.setHostRequirements(new AnyCapableBuildHostRequirements());
        } else if (this.buildHost == 1L) {
            this.stage.setHostRequirements(new MasterBuildHostRequirements());
        } else {
            Slave slave = this.slaveManager.getSlave(this.buildHost);
            this.stage.setHostRequirements(new SlaveBuildHostRequirements(slave));
        }
        if (!TextUtils.stringSet((String)this.stage.getRecipe())) {
            this.stage.setRecipe(null);
        }
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }
}

