/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.zutubi.pulse.filesystem.FileSystem;
import com.zutubi.pulse.filesystem.remote.RemoteScmFileSystem;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.web.project.AbstractBrowseDirAction;
import com.zutubi.pulse.web.project.AddProjectWizard;
import java.util.Map;

public class BrowseScmAction
extends AbstractBrowseDirAction {
    private long id;
    private String location;
    private boolean selectDir;
    private String elementId;
    private String prefix;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isSelectDir() {
        return this.selectDir;
    }

    public void setSelectDir(boolean selectDir) {
        this.selectDir = selectDir;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean getShowSizes() {
        return false;
    }

    public String execute() {
        Scm scm;
        if (this.id != 0L) {
            Project project = this.lookupProject(this.id);
            if (project == null) {
                return "error";
            }
            scm = project.getScm();
        } else {
            Map session = ActionContext.getContext().getSession();
            if (!session.containsKey(AddProjectWizard.class.getName())) {
                this.addActionError("Unable to locate SCM configuration from previous step");
                return "error";
            }
            AddProjectWizard wizard = (AddProjectWizard)session.get(AddProjectWizard.class.getName());
            scm = wizard.getScm();
        }
        try {
            this.location = scm.createServer().getLocation();
            if (TextUtils.stringSet((String)this.prefix) && !TextUtils.stringSet((String)this.getPath())) {
                this.setPath(this.prefix);
            }
            return super.execute((FileSystem)new RemoteScmFileSystem(scm));
        }
        catch (Exception e) {
            this.addActionError("Error browsing SCM: " + e.getMessage());
            return "error";
        }
    }
}

