/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.model.PersistentResource;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.web.ActionSupport;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseResourcesAction
extends ActionSupport {
    private String resourceId;
    private String versionId;
    private ResourceManager resourceManager;
    private Map<String, Map<String, Set<String>>> allResources = new TreeMap<String, Map<String, Set<String>>>();

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Map<String, Map<String, Set<String>>> getAllResources() {
        return this.allResources;
    }

    public String execute() throws Exception {
        List<PersistentResource> resources = this.resourceManager.findAll();
        for (PersistentResource resource : resources) {
            Map<String, Set<String>> versions = this.allResources.get(resource.getName());
            if (versions == null) {
                versions = new TreeMap<String, Set<String>>();
                this.allResources.put(resource.getName(), versions);
            }
            this.mergeVersions(resource, versions);
        }
        return "success";
    }

    private void mergeVersions(PersistentResource resource, Map<String, Set<String>> versions) {
        this.mergeVersion("", versions, resource);
        for (ResourceVersion version : resource.getVersions().values()) {
            this.mergeVersion(version.getValue(), versions, resource);
        }
    }

    private void mergeVersion(String version, Map<String, Set<String>> versions, PersistentResource resource) {
        Set<String> agents = versions.get(version);
        if (agents == null) {
            agents = new TreeSet<String>();
            versions.put(version, agents);
        }
        agents.add(this.getAgentName(resource));
    }

    private String getAgentName(PersistentResource resource) {
        Slave slave = resource.getSlave();
        if (slave == null) {
            return "master";
        }
        return slave.getName();
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public class VersionInfo {
        public String value;
        public Set<String> agents;

        public VersionInfo(String value) {
            this.value = value;
            this.agents = new TreeSet<String>();
        }

        public boolean equals(Object obj) {
            return obj instanceof VersionInfo && this.value.equals(((VersionInfo)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

