/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.filesystem.FileSystem;
import com.zutubi.pulse.filesystem.remote.RemoteScmFileSystem;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.AbstractBrowseDirAction;

public class BrowseProjectScmAction
extends AbstractBrowseDirAction {
    private long id;
    private Project project;
    private String location;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Project getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean getShowSizes() {
        return false;
    }

    public String execute() {
        this.project = this.getProjectManager().getProject(this.id);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.id + "]");
            return "error";
        }
        this.getProjectManager().checkWrite(this.project);
        try {
            this.location = this.project.getScm().createServer().getLocation();
            return super.execute((FileSystem)new RemoteScmFileSystem(this.project.getScm()));
        }
        catch (Exception e) {
            this.addActionError("Error browsing SCM: " + e.getMessage());
            return "error";
        }
    }
}

