/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.events.build.BuildCompletedEvent;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.scheduling.BuildCompletedEventFilter;
import com.zutubi.pulse.scheduling.CronTrigger;
import com.zutubi.pulse.scheduling.EventTrigger;
import com.zutubi.pulse.scheduling.SCMChangeEventFilter;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.tasks.BuildProjectTask;
import com.zutubi.pulse.scm.SCMChangeEvent;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.BuildCompletedTriggerHelper;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AddTriggerWizard
extends BaseWizard {
    private static final String MONITOR_STATE = "monitor";
    private static final String BUILD_COMPLETED_STATE = "build.completed";
    private static final String CRON_STATE = "cron";
    private static final Logger LOG = Logger.getLogger(AddTriggerWizard.class);
    private long projectId;
    private ProjectManager projectManager;
    private Scheduler scheduler;
    private SelectTriggerType selectState = new SelectTriggerType(this, "select");
    private ConfigureCronTrigger configCron = new ConfigureCronTrigger(this, "cron");
    private ConfigureBuildCompletedTrigger configBuildCompleted = new ConfigureBuildCompletedTrigger(this, "build.completed");

    public AddTriggerWizard() {
        this.addInitialState(this.selectState);
        this.addState(this.configCron);
        this.addState(this.configBuildCompleted);
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    public void process() {
        Project project = this.projectManager.getProject(this.getProjectId());
        Trigger trigger = null;
        boolean force = true;
        if (CRON_STATE.equals(this.selectState.getType())) {
            trigger = new CronTrigger(this.configCron.cron, this.selectState.getName(), project.getName());
        } else if (MONITOR_STATE.equals(this.selectState.getType())) {
            trigger = new EventTrigger(SCMChangeEvent.class, this.selectState.getName(), project.getName(), SCMChangeEventFilter.class);
            force = false;
        } else if (BUILD_COMPLETED_STATE.equals(this.selectState.getType())) {
            trigger = new EventTrigger(BuildCompletedEvent.class, this.selectState.getName(), project.getName(), BuildCompletedEventFilter.class);
            this.configBuildCompleted.getHelper().populateTrigger(trigger, this.configBuildCompleted.getFilterProject(), this.configBuildCompleted.getFilterSpecification(), this.configBuildCompleted.getFilterStateNames());
        }
        trigger.setProject(project.getId());
        trigger.setTaskClass(BuildProjectTask.class);
        trigger.getDataMap().put((Serializable)((Object)"spec"), Long.valueOf(this.selectState.getSpec()));
        if (force) {
            trigger.getDataMap().put((Serializable)((Object)"force"), Boolean.valueOf(true));
        }
        try {
            this.scheduler.schedule(trigger);
        }
        catch (SchedulingException e) {
            this.addActionError(e.getMessage());
            LOG.severe(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigureBuildCompletedTrigger
    extends BaseWizardState {
        private BuildCompletedTriggerHelper helper;
        private Long filterProject;
        private String filterSpecification;
        private List<String> filterStateNames;

        public ConfigureBuildCompletedTrigger(Wizard wizard, String stateName) {
            super(wizard, stateName);
            this.helper = new BuildCompletedTriggerHelper();
        }

        @Override
        public void initialise() {
            this.helper.initialise(AddTriggerWizard.this.projectManager);
        }

        public Map<Long, String> getFilterProjects() {
            return this.helper.getFilterProjects();
        }

        public Map<Long, List<String>> getFilterSpecifications() {
            return this.helper.getFilterSpecifications();
        }

        public Map<String, String> getStateMap() {
            return this.helper.getStateMap();
        }

        public Long getFilterProject() {
            return this.filterProject;
        }

        public void setFilterProject(Long filterProject) {
            this.filterProject = filterProject;
        }

        public String getFilterSpecification() {
            return this.filterSpecification;
        }

        public void setFilterSpecification(String filterSpecification) {
            this.filterSpecification = filterSpecification;
        }

        public List<String> getFilterStateNames() {
            return this.filterStateNames;
        }

        public void setFilterStateNames(List<String> filterStateNames) {
            this.filterStateNames = filterStateNames;
        }

        @Override
        public String getNextStateName() {
            return "success";
        }

        public BuildCompletedTriggerHelper getHelper() {
            return this.helper;
        }
    }

    public class ConfigureCronTrigger
    extends BaseWizardState {
        private String cron;

        public ConfigureCronTrigger(Wizard wizard, String stateName) {
            super(wizard, stateName);
        }

        public String getCron() {
            return this.cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public String getNextStateName() {
            return "success";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectTriggerType
    extends BaseWizardState
    implements Validateable {
        private Map<String, String> types;
        private String name;
        private long spec;
        private Map<Long, String> specs;
        private String type;

        public SelectTriggerType(Wizard wizard, String name) {
            super(wizard, name);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getSpec() {
            return this.spec;
        }

        public void setSpec(long spec) {
            this.spec = spec;
        }

        public Map<String, String> getTypes() {
            return this.types;
        }

        public Map<Long, String> getSpecs() {
            return this.specs;
        }

        public void validate() {
            if (!TextUtils.stringSet((String)this.type) || !this.types.containsKey(this.type)) {
                this.addFieldError("type", "invalid type '" + this.type + "' specified. ");
                return;
            }
            long projectId = ((AddTriggerWizard)this.getWizard()).getProjectId();
            if (AddTriggerWizard.this.scheduler.getTrigger(projectId, this.name) != null) {
                this.addFieldError("name", "the name " + this.name + " is already being used. please use a different name.");
            }
        }

        @Override
        public void initialise() {
            super.initialise();
            long projectId = ((AddTriggerWizard)this.getWizard()).getProjectId();
            Project project = AddTriggerWizard.this.projectManager.getProject(projectId);
            if (project == null) {
                this.addActionError("Unknown projectId '" + projectId + "'");
                return;
            }
            this.specs = new LinkedHashMap<Long, String>();
            for (BuildSpecification spec : project.getBuildSpecifications()) {
                this.specs.put(spec.getId(), spec.getName());
            }
            if (this.specs.size() == 0) {
                this.addActionError("No build specifications for projectId '" + project.getName() + "'");
            }
            if (this.types == null) {
                this.types = new TreeMap<String, String>();
                this.types.put(AddTriggerWizard.MONITOR_STATE, "monitor scm trigger");
                this.types.put(AddTriggerWizard.CRON_STATE, "cron trigger");
                this.types.put(AddTriggerWizard.BUILD_COMPLETED_STATE, "build completed");
            }
        }

        @Override
        public String getNextStateName() {
            if (TextUtils.stringSet((String)this.type)) {
                if (AddTriggerWizard.MONITOR_STATE.equals(this.type)) {
                    return "success";
                }
                return this.type;
            }
            return super.getStateName();
        }
    }
}

