/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.RunExecutablePostBuildAction;
import com.zutubi.pulse.model.TagPostBuildAction;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AddPostBuildActionWizard
extends BaseWizard {
    private static final String EXE_STATE = "exe";
    private static final String TAG_STATE = "tag";
    private long projectId;
    private long specId = 0L;
    private long nodeId = 0L;
    private ProjectManager projectManager;
    private BuildManager buildManager;
    private MasterConfigurationManager configurationManager;
    private SelectActionType selectState = new SelectActionType(this, "select");
    private ConfigureTag configTag = new ConfigureTag(this, "tag");
    private ConfigureExe configExe = new ConfigureExe(this, "exe");

    public AddPostBuildActionWizard() {
        this.addInitialState(this.selectState);
        this.addState(this.configTag);
        this.addState(this.configExe);
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public long getSpecId() {
        return this.specId;
    }

    public void setSpecId(long specId) {
        this.specId = specId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public Project getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    public boolean isStage() {
        return this.specId > 0L;
    }

    public boolean isExe() {
        return EXE_STATE.equals(this.selectState.getType());
    }

    public void process() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        PostBuildAction action = null;
        if (TAG_STATE.equals(this.selectState.getType())) {
            action = new TagPostBuildAction(this.selectState.getName(), project.lookupBuildSpecifications(this.selectState.getSpecIds()), ResultState.getStatesList(this.selectState.getStateNames()), this.selectState.getFailOnError(), this.configTag.getTagName(), this.configTag.getMoveExisting());
        } else if (EXE_STATE.equals(this.selectState.getType())) {
            action = new RunExecutablePostBuildAction(this.selectState.getName(), project.lookupBuildSpecifications(this.selectState.getSpecIds()), ResultState.getStatesList(this.selectState.getStateNames()), this.selectState.getFailOnError(), this.configExe.getCommand(), this.configExe.getArguments());
        }
        if (this.specId > 0L) {
            BuildSpecification spec = project.getBuildSpecification(this.specId);
            if (spec == null) {
                return;
            }
            BuildSpecificationNode node = spec.getNode(this.nodeId);
            if (node == null) {
                return;
            }
            node.addPostAction(action);
        } else {
            project.addPostBuildAction(action);
        }
        this.projectManager.save(project);
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public class ConfigureTag
    extends BaseWizardState {
        private String tagName;
        private boolean moveExisting;

        public ConfigureTag(Wizard wizard, String stateName) {
            super(wizard, stateName);
            this.moveExisting = false;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public boolean getMoveExisting() {
            return this.moveExisting;
        }

        public void setMoveExisting(boolean moveExisting) {
            this.moveExisting = moveExisting;
        }

        public String getNextStateName() {
            return "success";
        }
    }

    public class ConfigureExe
    extends BaseWizardState {
        private String command;
        private String arguments;
        private Scope exampleScope;

        public ConfigureExe(Wizard wizard, String stateName) {
            super(wizard, stateName);
        }

        public void initialise() {
            super.initialise();
            List<BuildResult> lastBuild = AddPostBuildActionWizard.this.buildManager.queryBuilds(new Project[]{AddPostBuildActionWizard.this.getProject()}, new ResultState[]{ResultState.SUCCESS}, null, -1L, -1L, null, 0, 1, true);
            if (!lastBuild.isEmpty()) {
                BuildResult result = lastBuild.get(0);
                List<RecipeResultNode> stages = result.getRoot().getChildren();
                RecipeResultNode node = null;
                if (AddPostBuildActionWizard.this.isStage() && stages.size() > 0) {
                    node = stages.get(0);
                }
                this.exampleScope = RunExecutablePostBuildAction.getScope(result, node, new LinkedList<ResourceProperty>(), AddPostBuildActionWizard.this.configurationManager);
            }
        }

        public Scope getExampleScope() {
            return this.exampleScope;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getArguments() {
            return this.arguments;
        }

        public void setArguments(String arguments) {
            this.arguments = arguments;
        }

        public String getNextStateName() {
            return "success";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectActionType
    extends BaseWizardState
    implements Validateable {
        private Map<String, String> types;
        private Map<Long, String> specs;
        private Map<String, String> states;
        private String name;
        private String type;
        private List<Long> specIds;
        private List<String> stateNames;
        private boolean failOnError;

        public SelectActionType(Wizard wizard, String name) {
            super(wizard, name);
            this.specIds = new LinkedList<Long>();
            this.stateNames = new LinkedList<String>();
            this.failOnError = false;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getTypes() {
            return this.types;
        }

        public Map<Long, String> getSpecs() {
            return this.specs;
        }

        public List<Long> getSpecIds() {
            return this.specIds;
        }

        public void setSpecIds(List<Long> specIds) {
            this.specIds = specIds;
        }

        public Map<String, String> getStates() {
            return this.states;
        }

        public List<String> getStateNames() {
            return this.stateNames;
        }

        public void setStateNames(List<String> stateNames) {
            this.stateNames = stateNames;
        }

        public boolean getFailOnError() {
            return this.failOnError;
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public void validate() {
            if (!TextUtils.stringSet((String)this.type) || !this.types.containsKey(this.type)) {
                this.addFieldError("type", "invalid type '" + this.type + "' specified. ");
                return;
            }
            Project project = AddPostBuildActionWizard.this.getProject();
            if (project == null) {
                return;
            }
            if (AddPostBuildActionWizard.this.specId > 0L) {
                BuildSpecification spec = project.getBuildSpecification(AddPostBuildActionWizard.this.specId);
                if (spec == null) {
                    return;
                }
                BuildSpecificationNode node = spec.getNode(AddPostBuildActionWizard.this.nodeId);
                if (node == null) {
                    return;
                }
                if (node.getPostAction(this.name) != null) {
                    this.addFieldError("name", "This stage already has a post stage action with name '" + this.name + "'");
                }
            } else if (project.getPostBuildAction(this.name) != null) {
                this.addFieldError("name", "This project already has a post build action with name '" + this.name + "'");
            }
        }

        @Override
        public void initialise() {
            super.initialise();
            Project project = AddPostBuildActionWizard.this.getProject();
            if (project == null) {
                this.addActionError("Unknown project [" + AddPostBuildActionWizard.this.projectId + "]");
                return;
            }
            if (AddPostBuildActionWizard.this.specId == 0L) {
                this.specs = new LinkedHashMap<Long, String>();
                List<BuildSpecification> buildSpecifications = project.getBuildSpecifications();
                Collections.sort(buildSpecifications, new NamedEntityComparator());
                for (BuildSpecification spec : buildSpecifications) {
                    this.specs.put(spec.getId(), spec.getName());
                }
            }
            this.states = ResultState.getCompletedStatesMap();
            if (this.types == null) {
                this.types = new LinkedHashMap<String, String>();
                this.types.put(AddPostBuildActionWizard.TAG_STATE, "apply tag");
                this.types.put(AddPostBuildActionWizard.EXE_STATE, "run executable");
            }
        }

        @Override
        public String getNextStateName() {
            if (TextUtils.stringSet((String)this.type)) {
                return this.type;
            }
            return super.getStateName();
        }
    }
}

