/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditPostBuildActionAction
extends ProjectActionSupport
implements Preparable {
    private long id;
    private long specId = 0L;
    private long nodeId = 0L;
    private Project project;
    private String newName;
    private boolean failOnError = false;
    private List<Long> specIds;
    private List<String> stateNames;
    private Map<Long, String> specs;
    private Map<String, String> states;
    private static final List<String> ID_PARAMS = Arrays.asList("id", "projectId", "specId", "nodeId");

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getSpecId() {
        return this.specId;
    }

    public void setSpecId(long specId) {
        this.specId = specId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public List<Long> getSpecIds() {
        return this.specIds;
    }

    public void setSpecIds(List<Long> specIds) {
        this.specIds = specIds;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    public boolean isStage() {
        return this.specId > 0L;
    }

    public Map<Long, String> getSpecs() {
        if (this.specs == null) {
            this.specs = new LinkedHashMap<Long, String>();
            List<BuildSpecification> buildSpecifications = this.project.getBuildSpecifications();
            Collections.sort(buildSpecifications, new NamedEntityComparator());
            for (BuildSpecification spec : buildSpecifications) {
                this.specs.put(spec.getId(), spec.getName());
            }
        }
        return this.specs;
    }

    public Map<String, String> getStates() {
        if (this.states == null) {
            this.states = ResultState.getCompletedStatesMap();
        }
        return this.states;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return ID_PARAMS;
    }

    public void prepare() throws Exception {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return;
        }
    }

    public String doInput() {
        if (this.hasErrors()) {
            return "error";
        }
        this.newName = this.getPostBuildAction().getName();
        this.failOnError = this.getPostBuildAction().getFailOnError();
        this.specIds = this.getPostBuildAction().getBuildSpecificationIds();
        this.stateNames = ResultState.getNames(this.getPostBuildAction().getStates());
        return "input";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (this.isStage()) {
            BuildSpecification spec = this.project.getBuildSpecification(this.specId);
            if (spec == null) {
                this.addActionError("Unknown build specification [" + this.specId + "]");
                return;
            }
            BuildSpecificationNode node = spec.getNode(this.nodeId);
            if (node == null) {
                this.addActionError("Unknown build stage [" + this.nodeId + "]");
                return;
            }
            PostBuildAction a = node.getPostAction(this.newName);
            if (a != null && a.getId() != this.getPostBuildAction().getId()) {
                this.addFieldError("newName", "This stage already has a post stage action with name '" + this.newName + "'");
            }
        } else {
            PostBuildAction a = this.getProject().getPostBuildAction(this.newName);
            if (a != null && a.getId() != this.getPostBuildAction().getId()) {
                this.addFieldError("newName", "This project already has a post build action with name '" + this.newName + "'");
            }
        }
    }

    public String execute() {
        if (this.hasErrors()) {
            return "error";
        }
        PostBuildAction action = this.getPostBuildAction();
        action.setName(this.newName);
        action.setSpecifications(this.project.lookupBuildSpecifications(this.specIds));
        action.setStates(ResultState.getStatesList(this.stateNames));
        action.setFailOnError(this.failOnError);
        this.getProjectManager().save(this.project);
        return "success";
    }

    protected PostBuildAction lookupAction() {
        PostBuildAction a;
        if (this.isStage()) {
            BuildSpecification spec = this.project.getBuildSpecification(this.getSpecId());
            if (spec == null) {
                this.addActionError("Unknown build specification [" + this.getSpecId() + "]");
                return null;
            }
            BuildSpecificationNode node = spec.getNode(this.getNodeId());
            if (node == null) {
                this.addActionError("Unknown build stage [" + this.getNodeId() + "]");
                return null;
            }
            a = node.getPostAction(this.getId());
        } else {
            a = this.project.getPostBuildAction(this.getId());
        }
        if (a == null) {
            this.addActionError("Unknown post build action [" + this.getId() + "]");
        }
        return a;
    }

    public abstract PostBuildAction getPostBuildAction();
}

