/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.persistence.PulseFileDetailsDao;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditDetailsAction
extends ProjectActionSupport
implements Preparable {
    private long id;
    private Project project;
    private PulseFileDetailsDao pulseFileDetailsDao;
    private static final List<String> PREPARE_PARAMS = Arrays.asList("id", "projectId");

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public PulseFileDetailsDao getPulseFileDetailsDao() {
        return this.pulseFileDetailsDao;
    }

    public void setPulseFileDetailsDao(PulseFileDetailsDao pulseFileDetailsDao) {
        this.pulseFileDetailsDao = pulseFileDetailsDao;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return PREPARE_PARAMS;
    }

    public void validate() {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
        }
    }

    public String doInput() throws Exception {
        this.prepare();
        if (this.getDetails() == null) {
            this.addActionError("Unknown project details '" + this.getId() + "'");
            return "error";
        }
        return "input";
    }

    public String execute() {
        if (this.getDetails() == null) {
            return "input";
        }
        this.getPulseFileDetailsDao().save(this.getDetails());
        return "success";
    }

    public abstract PulseFileDetails getDetails();
}

