/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.PostProcessorManager;
import com.zutubi.pulse.model.Capture;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditArtifactAction
extends ProjectActionSupport
implements Preparable {
    private static final List<String> PREPARE_PARAMS = Arrays.asList("id", "projectId");
    private long id;
    private long projectId;
    private Project project;
    private String name;
    private Capture capture;
    private List<String> processors;
    private Map<String, String> processorList;
    private PostProcessorManager postProcessorManager;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Capture getCapture() {
        return this.capture;
    }

    public List<String> getProcessors() {
        if (this.processors == null) {
            this.processors = this.capture.getProcessors();
        }
        return this.processors;
    }

    public void setProcessors(List<String> processors) {
        this.processors = processors;
    }

    public Map<String, String> getProcessorList() {
        if (this.processorList == null) {
            this.processorList = this.postProcessorManager.getAvailableProcessors();
        }
        return this.processorList;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return PREPARE_PARAMS;
    }

    private void validateProject() {
        if (this.project != null) {
            return;
        }
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return;
        }
        if (!this.project.getPulseFileDetails().isBuiltIn()) {
            this.addActionError("Invalid operation for project");
        }
    }

    public void validate() {
        this.validateProject();
        if (this.hasErrors()) {
            return;
        }
        TemplatePulseFileDetails details = (TemplatePulseFileDetails)this.project.getPulseFileDetails();
        Capture sameName = details.getCapture(this.name);
        if (sameName != null && sameName.getId() != this.capture.getId()) {
            this.addFieldError("name", "the name " + this.name + " is already being used");
        }
    }

    public void prepare() throws Exception {
        this.validateProject();
        if (this.hasErrors()) {
            return;
        }
        this.capture = ((TemplatePulseFileDetails)this.project.getPulseFileDetails()).getCapture(this.id);
        if (this.capture == null) {
            this.addActionError("Unknown artifact [" + this.id + "]");
            return;
        }
        if (!this.verifyCapture(this.capture)) {
            this.addActionError("Invalid operation for artifact");
        }
        this.name = this.capture.getName();
        this.processors = this.capture.getProcessors();
    }

    public String doInput() throws Exception {
        this.prepare();
        if (this.hasErrors()) {
            return "error";
        }
        return "input";
    }

    public String execute() {
        this.capture.setName(this.name);
        List<String> procs = this.capture.getProcessors();
        procs.clear();
        if (this.processors != null) {
            procs.addAll(this.processors);
        }
        this.capture.clearFields();
        this.getProjectManager().save(this.project);
        return "success";
    }

    protected abstract boolean verifyCapture(Capture var1);

    public void setPostProcessorManager(PostProcessorManager postProcessorManager) {
        this.postProcessorManager = postProcessorManager;
    }
}

