/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.agents;

import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.model.PersistentResource;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.util.Sort;
import com.zutubi.pulse.web.agents.AgentActionSupport;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewResourceAction
extends AgentActionSupport {
    private long resourceId;
    private PersistentResource resource;
    private ResourceManager resourceManager;
    private long selectedNode;
    private List<ResourceVersion> versions;

    public long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(PersistentResource resource) {
        this.resource = resource;
    }

    public List<ResourceVersion> getVersions() {
        return this.versions;
    }

    public long getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(long selectedNode) {
        this.selectedNode = selectedNode;
    }

    public boolean haveSelectedNode() {
        return this.selectedNode != 0L;
    }

    public boolean isDefaultVersion(String version) {
        return version.equals(this.resource.getDefaultVersion());
    }

    public String execute() {
        this.resource = this.resourceManager.findById(this.resourceId);
        if (this.resource == null) {
            this.addActionError("Unknown resource [" + this.resourceId + "]");
            return "error";
        }
        this.slave = this.resource.getSlave();
        this.versions = new LinkedList(this.resource.getVersions().values());
        Sort.StringComparator comp = new Sort.StringComparator();
        Collections.sort(this.versions, new Comparator<ResourceVersion>((Comparator)comp){
            final /* synthetic */ Comparator val$comp;
            {
                this.val$comp = comparator;
            }

            @Override
            public int compare(ResourceVersion v1, ResourceVersion v2) {
                return this.val$comp.compare(v1.getValue(), v2.getValue());
            }
        });
        return "success";
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

