/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.web.PagingSupport;
import com.zutubi.pulse.web.admin.user.GroupsActionSupport;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGroupsAction
extends GroupsActionSupport {
    public static final int GROUPS_PER_PAGE = 20;
    private List<Group> groups;
    private PagingSupport pagingSupport = new PagingSupport(20);

    public List<Group> getGroups() {
        return this.groups;
    }

    public PagingSupport getPagingSupport() {
        return this.pagingSupport;
    }

    public int getStartPage() {
        return this.pagingSupport.getStartPage();
    }

    public void setStartPage(int page) {
        this.pagingSupport.setStartPage(page);
    }

    public String execute() {
        this.groups = this.getUserManager().getAllGroups();
        Collections.sort(this.groups, new NamedEntityComparator());
        this.pagingSupport.setTotalItems(this.groups.size());
        this.pagingSupport.clampStartPage();
        this.groups = this.groups.subList(this.pagingSupport.getStartOffset(), this.pagingSupport.getEndOffset());
        return "success";
    }
}

