/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.UserLoginComparator;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.PagingSupport;
import com.zutubi.pulse.web.admin.user.GroupActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGroupMembersAction
extends GroupActionSupport {
    public static int USERS_PER_PAGE = 20;
    private List<User> users;
    private PagingSupport pagingSupport = new PagingSupport(USERS_PER_PAGE);

    public PagingSupport getPagingSupport() {
        return this.pagingSupport;
    }

    public int getStartPage() {
        return this.pagingSupport.getStartPage();
    }

    public void setStartPage(int page) {
        this.pagingSupport.setStartPage(page);
    }

    public List<User> getUsers() {
        return this.users;
    }

    public String execute() throws Exception {
        Group group = this.getGroup();
        if (group == null) {
            this.addActionError("Unknown group [" + this.getGroupId() + "]");
            return "error";
        }
        this.users = new ArrayList<User>(group.getUsers());
        Collections.sort(this.users, new UserLoginComparator());
        this.pagingSupport.setTotalItems(this.users.size());
        this.pagingSupport.clampStartPage();
        this.users = this.users.subList(this.pagingSupport.getStartOffset(), this.pagingSupport.getEndOffset());
        this.setStartPage(this.getGroupStartPage(group));
        return "success";
    }
}

