/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.User;
import com.zutubi.pulse.util.RandomUtils;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.web.user.UserActionSupport;

public class EditPasswordAction
extends UserActionSupport {
    private String password;
    private String confirm;
    private int startPage = 0;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (this.getUser() == null) {
            this.addUnknownUserFieldError();
            return;
        }
        if (!StringUtils.equals((String)this.password, (String)this.confirm)) {
            this.addFieldError("confirm", this.getText("password.confirm.mismatch"));
        }
    }

    public String doReset() {
        String rawPassword = RandomUtils.randomString((int)8);
        User user = this.getUser();
        this.getUserManager().setPassword(user, rawPassword);
        this.getUserManager().save(user);
        this.startPage = this.getUserStartPage(user);
        return "success";
    }

    public String execute() {
        User user = this.getUser();
        this.getUserManager().setPassword(user, this.password);
        this.getUserManager().save(user);
        this.startPage = this.getUserStartPage(user);
        return "success";
    }
}

