/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.User;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.web.user.UserActionSupport;

public class DeleteUserAction
extends UserActionSupport {
    private int startPage = 0;

    public int getStartPage() {
        return this.startPage;
    }

    public void validate() {
        User user = this.getUser();
        if (user == null) {
            this.addUnknownUserActionError();
            return;
        }
        String loggedInUser = AcegiUtils.getLoggedInUser();
        String login = user.getLogin();
        if (login.equals(loggedInUser)) {
            this.addActionError(this.getText("user.delete.self"));
        }
        if (this.isAdminUser(user)) {
            this.addActionError(this.getText("user.delete.admin"));
        }
    }

    public String execute() {
        User user = this.getUser();
        this.startPage = this.getUserStartPage(user);
        this.getUserManager().delete(user);
        return "success";
    }
}

